/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public interface RenderHelper {
    public static final int SPACING = 4;
    public static final int SHADOW_LIGHT_COLOR = 0xF000F0;

    default public void drawStack(GuiGraphics context, ItemStack stack, int x, int y, float size) {
        boolean bl;
        if (stack.m_41619_()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        BakedModel bakedModel = client.m_91291_().m_174264_(stack, (Level)client.f_91073_, (LivingEntity)client.f_91074_, 0);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)x + size / 2.0f, (float)y + size / 2.0f, 150.0f);
        matrices.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.m_85841_(size, size, size);
        boolean bl2 = bl = !bakedModel.m_7547_();
        if (bl) {
            Lighting.m_84930_();
        }
        client.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrices, (MultiBufferSource)context.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        context.m_280262_();
        if (bl) {
            Lighting.m_84931_();
        }
        matrices.m_85849_();
    }

    default public void drawEntity(GuiGraphics context, int centerX, int centerY, int maxSize, float rotationYaw, LivingEntity entity) {
        float pitch = entity.m_146909_();
        float yaw = entity.m_146908_();
        float bodyYaw = entity.f_20883_;
        float headYaw = entity.f_20885_;
        entity.m_146926_(0.0f);
        entity.m_146922_(rotationYaw);
        entity.f_20883_ = rotationYaw;
        entity.f_20885_ = rotationYaw;
        double boxX = entity.m_20191_().m_82362_();
        double boxY = entity.m_20191_().m_82376_();
        double scale = (boxX + boxY) / 2.0;
        Quaternionf correctionRotation = entity instanceof Cod || entity instanceof Salmon ? new Quaternionf().rotateZ((float)Math.toRadians(-90.0)) : new Quaternionf().rotateX((float)Math.toRadians(180.0));
        Quaternionf combinedRotation = new Quaternionf().rotateY((float)Math.toRadians(rotationYaw)).mul((Quaternionfc)correctionRotation);
        if (entity instanceof AbstractSchoolingFish) {
            centerY -= 20;
            scale *= 1.5;
        }
        this.drawEntity(context, (double)centerX - boxX / 2.0, (double)centerY - boxY / 2.0, (float)((double)maxSize / scale), combinedRotation, (Entity)entity);
        entity.m_146926_(pitch);
        entity.m_146922_(yaw);
        entity.f_20883_ = bodyYaw;
        entity.f_20885_ = headYaw;
    }

    default public void drawEntity(GuiGraphics context, double x, double y, float size, Quaternionf rotation, Entity entity) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_(x, y, 450.0);
        matrices.m_85841_(-1.0f, 1.0f, 1.0f);
        matrices.m_252931_(new Matrix4f().scaling(size, size, size));
        matrices.m_252781_(rotation);
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.m_280168_(), (MultiBufferSource)context.m_280091_(), 0xF000F0);
        dispatcher.m_114468_(true);
        matrices.m_85849_();
        Lighting.m_84931_();
    }
}

