/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.hook.RarityHook;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipProviders {
    public static Component getRarityName(ItemStack stack) {
        return Component.m_237115_((String)"rarity.%s.%s".formatted("tooltips_reforged", stack.m_41791_().name().toLowerCase())).m_6270_(Style.f_131099_.m_178520_(-6250336));
    }

    public static Component getDisplayName(ItemStack stack) {
        return RarityHook.applyColor(Component.m_237119_(), stack.m_41791_()).m_7220_(stack.m_41786_());
    }

    public static int getItemBorderColor(ItemStack stack) {
        Integer color = null;
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.useNameColor.getValue()).booleanValue()) {
            color = TextUtil.getColorFromTranslation(TooltipProviders.getDisplayName(stack));
        }
        if (color == null || color == -1) {
            Rarity rarity = stack.m_41791_();
            TextColor textColor = RarityHook.applyColor(Component.m_237119_(), rarity).m_7383_().m_131135_();
            if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.overwriteRarityColor.getValue()).booleanValue()) {
                if (rarity == Rarity.COMMON) {
                    textColor = TextColor.m_131266_((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.commonRarityColor.getValue()));
                } else if (rarity == Rarity.UNCOMMON) {
                    textColor = TextColor.m_131266_((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.uncommonRarityColor.getValue()));
                } else if (rarity == Rarity.RARE) {
                    textColor = TextColor.m_131266_((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.rareRarityColor.getValue()));
                } else if (rarity == Rarity.EPIC) {
                    textColor = TextColor.m_131266_((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.epicRarityColor.getValue()));
                }
            }
            if ((color = textColor != null ? Integer.valueOf(textColor.m_131265_()) : rarity.f_43022_.m_126665_()) == null || color == 0xFFFFFF) {
                color = -1;
            }
        }
        return color;
    }
}

