/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.iafenvoy.integration.entrypoint.EntryPointManager;
import com.iafenvoy.tooltipsreforged.BuiltinTooltips;
import com.iafenvoy.tooltipsreforged.TooltipReforgedClient;
import com.iafenvoy.tooltipsreforged.api.TooltipsReforgeEntrypoint;
import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.ExtendedTooltipBackgroundRenderer;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector2ic;

@OnlyIn(value=Dist.CLIENT)
public class TooltipsRenderHelper {
    private static final int EDGE_SPACING = 32;
    private static final int PAGE_SPACING = 12;

    public static void render(ItemStack stack, List<ClientTooltipComponent> components, GuiGraphics context, Font textRenderer, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        BuiltinTooltips.appendTooltip(stack, components);
        EntryPointManager.getEntryPoints((String)"tooltips_reforged", TooltipsReforgeEntrypoint.class).forEach(e -> e.appendTooltip(stack, components));
        components.removeIf(Objects::isNull);
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.removeEmptyLines.getValue()).booleanValue()) {
            components.removeIf(x -> {
                ClientTextTooltip ordered;
                return x instanceof ClientTextTooltip && ExtendedTextVisitor.getText(TextUtil.getTextFromComponent(ordered = (ClientTextTooltip)x)).getString().isEmpty();
            });
        }
        ResolveResult result = TooltipsRenderHelper.resolveTooltips(textRenderer, components);
        Vector2ic position = TooltipsRenderHelper.resolvePosition(result, context, mouseX, mouseY, positioner);
        TooltipsRenderHelper.drawWithResult(result, stack, context, textRenderer, position.x(), position.y());
    }

    public static ResolveResult resolveTooltips(Font textRenderer, List<ClientTooltipComponent> components) {
        if (components.isEmpty()) {
            return new ResolveResult(List.of(), List.of(), 0);
        }
        LinkedList<Page> pageList = new LinkedList<Page>();
        LinkedList<StandaloneComponent> standaloneComponents = new LinkedList<StandaloneComponent>();
        int maxWidth = TooltipsRenderHelper.getMaxWidth();
        int maxHeight = TooltipsRenderHelper.getMaxHeight();
        int totalWidth = 0;
        int pageHeight = -2;
        Page p = new Page();
        for (ClientTooltipComponent component : components) {
            if (component instanceof StandaloneComponent) {
                StandaloneComponent standalone = (StandaloneComponent)component;
                standaloneComponents.add(standalone);
                continue;
            }
            int width = component.m_142069_(textRenderer);
            int height = component.m_142103_();
            if (width > maxWidth) {
                int wrappedWidth = component.m_142069_(textRenderer);
                int wrappedHeight = component.m_142103_();
                if (pageHeight + wrappedHeight > maxHeight) {
                    pageList.add(p);
                    totalWidth += p.width;
                    p = new Page();
                    pageHeight = -2;
                }
                p.components.add(component);
                p.height = pageHeight += wrappedHeight;
                p.width = Math.max(p.width, wrappedWidth);
                continue;
            }
            if (pageHeight + height > maxHeight) {
                pageList.add(p);
                totalWidth += p.width;
                p = new Page();
                pageHeight = -2;
            }
            p.components.add(component);
            p.height = pageHeight += height;
            p.width = Math.max(p.width, width);
        }
        if (!p.components.isEmpty()) {
            pageList.add(p);
            totalWidth += p.width;
        }
        return new ResolveResult(pageList, standaloneComponents, totalWidth);
    }

    public static Vector2ic resolvePosition(ResolveResult result, GuiGraphics context, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        return positioner.m_262814_(context.m_280182_(), context.m_280206_(), mouseX, mouseY, result.totalWidth, result.pages.get((int)0).height);
    }

    public static void drawWithResult(ResolveResult result, ItemStack stack, GuiGraphics context, Font textRenderer, int x, int y) {
        if (result.pages.isEmpty()) {
            return;
        }
        int currentX = x;
        for (Page page : result.pages) {
            page.x = currentX;
            page.y = y - (result.pages.size() > 1 ? 32 : 6);
            currentX += page.width + 12;
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        for (Page page : result.pages) {
            ExtendedTooltipBackgroundRenderer.render(stack, context, page.x, page.y, page.width, page.height, 0);
            int currentY = page.y;
            for (ClientTooltipComponent component : page.components) {
                try {
                    component.m_142440_(textRenderer, page.x, currentY, context.m_280168_().m_85850_().m_252922_(), context.m_280091_());
                    component.m_183452_(textRenderer, page.x, currentY, context);
                    currentY += component.m_142103_();
                }
                catch (Exception e) {
                    TooltipReforgedClient.LOGGER.error("{}", (Object)"tooltips_reforged", (Object)e);
                }
            }
        }
        for (StandaloneComponent component : result.standalone) {
            try {
                component.render(context, textRenderer, x, y, 0);
            }
            catch (Exception e) {
                TooltipReforgedClient.LOGGER.error("{}", (Object)"tooltips_reforged", (Object)e);
            }
        }
        context.m_280168_().m_85849_();
    }

    private static int getMaxHeight() {
        return Minecraft.m_91087_().m_91268_().m_85446_() - 64;
    }

    private static int getMaxWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 32;
    }

    public static void drawNineSlicedTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int border, int textureWidth, int textureHeight) {
        context.m_280163_(texture, x, y, 0.0f, 0.0f, border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y, width - border * 2, border, border, 0, textureWidth - border * 2, border, textureWidth, textureHeight);
        context.m_280163_(texture, x + width - border, y, (float)(textureWidth - border), 0.0f, border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x, y + border, border, height - border * 2, 0, border, border, textureHeight - border * 2, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y + border, width - border * 2, height - border * 2, border, border, textureWidth - border * 2, textureHeight - border * 2, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + width - border, y + border, border, height - border * 2, textureWidth - border, border, border, textureHeight - border * 2, textureWidth, textureHeight);
        context.m_280163_(texture, x, y + height - border, 0.0f, (float)(textureHeight - border), border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y + height - border, width - border * 2, border, border, textureHeight - border, textureWidth - border * 2, border, textureWidth, textureHeight);
        context.m_280163_(texture, x + width - border, y + height - border, (float)(textureWidth - border), (float)(textureHeight - border), border, border, textureWidth, textureHeight);
    }

    public static void drawRepeatingTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        int j;
        int i = 0;
        while (i + regionWidth < width) {
            j = 0;
            while (j + regionHeight < height) {
                context.m_280163_(texture, x + i, y + j, (float)u, (float)v, regionWidth, regionHeight, textureWidth, textureHeight);
                j += regionHeight;
            }
            context.m_280163_(texture, x + i, y + j, (float)u, (float)v, regionWidth, height - j, textureWidth, textureHeight);
            i += regionWidth;
        }
        j = 0;
        while (j + regionHeight < height) {
            context.m_280163_(texture, x + i, y + j, (float)u, (float)v, width - i, regionHeight, textureWidth, textureHeight);
            j += regionHeight;
        }
        context.m_280163_(texture, x + i, y + j, (float)u, (float)v, width - i, height - j, textureWidth, textureHeight);
    }

    public record ResolveResult(List<Page> pages, List<StandaloneComponent> standalone, int totalWidth) {
    }

    public static class Page {
        private int x;
        private int y;
        private int width;
        private int height;
        private final List<ClientTooltipComponent> components;

        private Page() {
            this(0, 0, 0, 0, new LinkedList<ClientTooltipComponent>());
        }

        private Page(int x, int y, int width, int height, List<ClientTooltipComponent> components) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.components = components;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

