/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.TooltipReforgedClient;
import com.iafenvoy.tooltipsreforged.util.NbtProcessor;
import it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class InfoCollectHelper {
    private static final List<Attribute> ATTRIBUTES = List.of(Attributes.f_22276_, Attributes.f_22279_, Attributes.f_22281_, Attributes.f_22284_, Attributes.f_22277_, Attributes.f_22278_, Attributes.f_22282_);
    private static final Map<EnchantmentCategory, List<Item>> TARGET_ITEMS_MAP = new HashMap<EnchantmentCategory, List<Item>>();

    public static List<String> collectItemTags(ItemStack stack) {
        return BuiltInRegistries.f_257033_.m_263177_((Object)stack.m_41720_()).m_203616_().map(TagKey::f_203868_).map(x -> "#" + x.toString()).toList();
    }

    public static List<String> collectBlockTags(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return BuiltInRegistries.f_256975_.m_263177_((Object)blockItem.m_40614_()).m_203616_().map(TagKey::f_203868_).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<String> collectEntityTags(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem eggItem = (SpawnEggItem)item;
            return BuiltInRegistries.f_256780_.m_263177_((Object)eggItem.m_43228_(stack.m_41783_())).m_203616_().map(TagKey::f_203868_).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<MutableComponent> collectEntityInfo(ItemStack stack) {
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem eggItem = (SpawnEggItem)item;
            if (world != null && (item = eggItem.m_43228_(stack.m_41783_()).m_20615_((Level)world)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)item;
                DecimalFormat df = new DecimalFormat("#.##");
                ATTRIBUTES.forEach(attribute -> {
                    AttributeInstance instance = living.m_21051_(attribute);
                    if (instance != null) {
                        list.add(Component.m_237115_((String)attribute.m_22087_()).m_130946_(": ").m_130946_(df.format(instance.m_22135_())).m_130940_(ChatFormatting.GRAY));
                    }
                });
                list.add(Component.m_237115_((String)"text.tooltips_reforged.mob_type").m_7220_((Component)Component.m_237115_((String)InfoCollectHelper.getMobType(living.m_6336_()))).m_130940_(ChatFormatting.GRAY));
            }
        }
        return list;
    }

    public static List<MutableComponent> collectNbt(ItemStack stack) {
        return NbtProcessor.process(stack);
    }

    private static String getMobType(MobType type) {
        if (type == MobType.f_21640_) {
            return "type.tooltips_reforged.default";
        }
        if (type == MobType.f_21641_) {
            return "type.tooltips_reforged.undead";
        }
        if (type == MobType.f_21642_) {
            return "type.tooltips_reforged.arthropod";
        }
        if (type == MobType.f_21643_) {
            return "type.tooltips_reforged.illager";
        }
        if (type == MobType.f_21644_) {
            return "type.tooltips_reforged.aquatic";
        }
        return "";
    }

    @Nullable
    public static ObjectLongPair<ResourceLocation> collectLootTable(ItemStack stack) {
        CompoundTag nbt = BlockItem.m_186336_((ItemStack)stack);
        if (nbt != null && nbt.m_128425_("LootTable", 8)) {
            return new ObjectLongImmutablePair((Object)ResourceLocation.m_135820_((String)nbt.m_128461_("LootTable")), nbt.m_128454_("LootTableSeed"));
        }
        return null;
    }

    public static List<Item> getEnchantmentTarget(EnchantmentCategory target) {
        return TARGET_ITEMS_MAP.getOrDefault(target, List.of());
    }

    @Nullable
    public static NonNullList<ItemStack> collectContainer(ItemStack stack) {
        NonNullList stacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        CompoundTag nbt = BlockItem.m_186336_((ItemStack)stack);
        if (nbt == null || !nbt.m_128425_("Items", 9)) {
            return null;
        }
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)stacks);
        return stacks;
    }

    static {
        for (EnchantmentCategory target : EnchantmentCategory.values()) {
            try {
                TARGET_ITEMS_MAP.put(target, BuiltInRegistries.f_257033_.m_123024_().filter(arg_0 -> ((EnchantmentCategory)target).m_7454_(arg_0)).toList());
            }
            catch (Throwable e) {
                TooltipReforgedClient.LOGGER.error("Failed to load items for enchantment target {}", (Object)target.name(), (Object)e);
            }
        }
    }
}

