/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.mixin.KeyBindingAccessor;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipKeyManager {
    private static final String CATEGORY = "category.%s.keys".formatted("tooltips_reforged");
    public static final KeyMapping SHOW_SPECIFIC_INFO = new KeyMapping("keybinding.%s.show_specific_info".formatted("tooltips_reforged"), 344, CATEGORY);
    public static final KeyMapping SHOW_NBT_SPAWN_EGG = new KeyMapping("keybinding.%s.show_nbt_spawn_egg".formatted("tooltips_reforged"), 346, CATEGORY);
    public static final KeyMapping SHOW_ITEM_TAG = new KeyMapping("keybinding.%s.show_item_tag".formatted("tooltips_reforged"), 345, CATEGORY);
    private boolean pressing;
    private Pressed pressed;

    private static InputConstants.Key getBoundKey(KeyMapping binding) {
        return ((KeyBindingAccessor)binding).getBoundKey();
    }

    private static boolean pressed(KeyMapping binding) {
        return !TooltipKeyManager.isUnknownKey(binding) && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)TooltipKeyManager.getBoundKey(binding).m_84873_());
    }

    private static boolean isUnknownKey(KeyMapping binding) {
        return TooltipKeyManager.getBoundKey(binding) == InputConstants.f_84822_;
    }

    public void renderTick() {
        if (TooltipKeyManager.pressed(SHOW_ITEM_TAG)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.ITEM_TAG ? Pressed.NONE : Pressed.ITEM_TAG;
                this.pressing = true;
            }
        } else if (TooltipKeyManager.pressed(SHOW_SPECIFIC_INFO)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.SPECIFIC ? Pressed.NONE : Pressed.SPECIFIC;
                this.pressing = true;
            }
        } else if (TooltipKeyManager.pressed(SHOW_NBT_SPAWN_EGG)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.NBT ? Pressed.NONE : Pressed.NBT;
                this.pressing = true;
            }
        } else {
            this.pressing = false;
        }
    }

    public PressState itemTag() {
        return TooltipKeyManager.isUnknownKey(SHOW_ITEM_TAG) ? PressState.HIDE : (this.pressed == Pressed.ITEM_TAG ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public PressState specific() {
        return TooltipKeyManager.isUnknownKey(SHOW_SPECIFIC_INFO) ? PressState.HIDE : (this.pressed == Pressed.SPECIFIC ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public PressState nbt() {
        return TooltipKeyManager.isUnknownKey(SHOW_NBT_SPAWN_EGG) ? PressState.HIDE : (this.pressed == Pressed.NBT ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public static String itemTagKeyTranslation() {
        return I18n.m_118938_((String)SHOW_ITEM_TAG.m_90865_(), (Object[])new Object[0]);
    }

    public static String specificKeyTranslation() {
        return I18n.m_118938_((String)SHOW_SPECIFIC_INFO.m_90865_(), (Object[])new Object[0]);
    }

    public static String nbtKeyTranslation() {
        return I18n.m_118938_((String)SHOW_NBT_SPAWN_EGG.m_90865_(), (Object[])new Object[0]);
    }

    private static enum Pressed {
        NONE,
        ITEM_TAG,
        SPECIFIC,
        NBT;

    }

    public static enum PressState {
        HIDE(false, false),
        UNPRESSED(true, false),
        PRESSED(true, true);

        private final boolean show;
        private final boolean showDetail;

        private PressState(boolean show, boolean showDetail) {
            this.show = show;
            this.showDetail = showDetail;
        }

        public boolean show() {
            return this.show;
        }

        public boolean showDetail() {
            return this.showDetail;
        }
    }
}

