/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged;

import com.iafenvoy.tooltipsreforged.component.BannerPatternComponent;
import com.iafenvoy.tooltipsreforged.component.ContainerPreviewComponent;
import com.iafenvoy.tooltipsreforged.component.DebugInfoComponent;
import com.iafenvoy.tooltipsreforged.component.DurabilityComponent;
import com.iafenvoy.tooltipsreforged.component.EnchantmentsComponent;
import com.iafenvoy.tooltipsreforged.component.EntityViewerComponent;
import com.iafenvoy.tooltipsreforged.component.EquipmentCompareComponent;
import com.iafenvoy.tooltipsreforged.component.EquipmentViewerComponent;
import com.iafenvoy.tooltipsreforged.component.FoodEffectComponent;
import com.iafenvoy.tooltipsreforged.component.HeaderComponent;
import com.iafenvoy.tooltipsreforged.component.ItemZoomComponent;
import com.iafenvoy.tooltipsreforged.component.MapComponent;
import com.iafenvoy.tooltipsreforged.component.PaintingComponent;
import com.iafenvoy.tooltipsreforged.component.PotionEffectsComponent;
import com.iafenvoy.tooltipsreforged.mixin.DecorationItemAccessor;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.SkullBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuiltinTooltips {
    public static void appendTooltip(ItemStack stack, List<ClientTooltipComponent> components, RegistryAccess registries) {
        DecorationItemAccessor accessor;
        BlockItem blockItem;
        Item item;
        if (!components.isEmpty()) {
            components.removeFirst();
        }
        LinkedList<ClientTooltipComponent> headers = new LinkedList<ClientTooltipComponent>();
        headers.add(new HeaderComponent(stack));
        headers.add(new ItemZoomComponent(stack));
        if (stack.getItem() instanceof LingeringPotionItem) {
            headers.add(new PotionEffectsComponent(stack, 0.25f));
        } else if (stack.getItem() instanceof PotionItem) {
            headers.add(new PotionEffectsComponent(stack, 1.0f));
        } else if (stack.getItem() instanceof TippedArrowItem) {
            headers.add(new PotionEffectsComponent(stack, 0.125f));
        }
        if (stack.has(DataComponents.FOOD)) {
            headers.add(new FoodEffectComponent(stack));
        }
        if (stack.getItem() instanceof EnchantedBookItem) {
            headers.add(new EnchantmentsComponent((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
        }
        if (stack.getItem().isEnchantable(stack)) {
            headers.add(new EnchantmentsComponent(stack.getEnchantments()));
        }
        components.addAll(0, headers);
        if (stack.getItem() instanceof Equipable || (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SkullBlock) {
            components.add(new EquipmentViewerComponent(stack));
            components.add(new EquipmentCompareComponent(stack));
        }
        if (stack.getItem() instanceof MobBucketItem || stack.getItem() instanceof SpawnEggItem) {
            components.add(new EntityViewerComponent(stack));
        }
        components.add(new ContainerPreviewComponent(stack, (HolderLookup.Provider)registries));
        if (stack.getItem() instanceof MapItem) {
            components.add(new MapComponent(stack));
        }
        if ((item = stack.getItem()) instanceof DecorationItemAccessor && (accessor = (DecorationItemAccessor)item).getEntityType() == EntityType.PAINTING) {
            components.add(new PaintingComponent(stack));
        }
        if (stack.getItem() instanceof BannerPatternItem) {
            components.add(new BannerPatternComponent(stack, registries));
        }
        components.add(new DurabilityComponent(stack));
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            components.add(new DebugInfoComponent(stack, registries));
        }
    }
}

