/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BannerPatternComponent
implements ClientTooltipComponent {
    private final Material texture;

    public BannerPatternComponent(ItemStack stack, RegistryAccess registries) {
        this.texture = BannerPatternComponent.getPatternsFor(stack, registries).stream().findFirst().map(Sheets::getBannerMaterial).orElse(null);
    }

    public int getHeight() {
        return this.texture != null && (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bannerTooltip.getValue() != false ? 50 : 0;
    }

    public int getWidth(Font textRenderer) {
        return this.texture != null && (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bannerTooltip.getValue() != false ? 20 : 0;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (this.texture == null || !((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bannerTooltip.getValue()).booleanValue()) {
            return;
        }
        context.blit(this.texture.texture().withPrefix("textures/").withSuffix(".png"), x, y, 22, 42, 0.0f, 0.0f, 22, 42, 64, 64);
    }

    private static List<Holder<BannerPattern>> getPatternsFor(ItemStack stack, RegistryAccess registries) {
        Registry registry = registries.registryOrThrow(Registries.BANNER_PATTERN);
        if (stack.isEmpty()) {
            return (List)registry.getTag(BannerPatternTags.NO_ITEM_REQUIRED).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = stack.getItem();
        if (item instanceof BannerPatternItem) {
            BannerPatternItem pattern = (BannerPatternItem)item;
            return (List)registry.getTag(pattern.getBannerPattern()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }
}

