/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.util.InfoCollectHelper;
import com.iafenvoy.tooltipsreforged.util.TooltipKeyManager;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DebugInfoComponent
implements ClientTooltipComponent {
    private static final TooltipKeyManager KEY_MANAGER = new TooltipKeyManager();
    private final List<String> itemTags;
    private final List<String> blockTags;
    private final List<String> entityTags;
    private final List<MutableComponent> nbt;
    private final List<MutableComponent> entityInfo;
    private final ObjectLongPair<ResourceLocation> lootTable;

    public DebugInfoComponent(ItemStack stack, RegistryAccess registries) {
        this.itemTags = InfoCollectHelper.collectItemTags(stack);
        this.blockTags = InfoCollectHelper.collectBlockTags(stack);
        this.entityTags = InfoCollectHelper.collectEntityTags(stack);
        this.nbt = InfoCollectHelper.collectNbt(stack, registries);
        this.entityInfo = InfoCollectHelper.collectEntityInfo(stack);
        this.lootTable = InfoCollectHelper.collectLootTable(stack);
    }

    public int getHeight() {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue() != false ? this.getDisplayTexts().size() * 10 : 0;
    }

    public int getWidth(Font textRenderer) {
        return this.getDisplayTexts().stream().map(arg_0 -> ((Font)textRenderer).width(arg_0)).reduce(0, Math::max, Math::max);
    }

    public void renderText(Font textRenderer, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource vertexConsumers) {
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue()).booleanValue()) {
            return;
        }
        float currentY = y + 1;
        for (Component component : this.getDisplayTexts()) {
            textRenderer.drawInBatch(component, (float)x, currentY, -1, true, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            currentY += 10.0f;
        }
        KEY_MANAGER.renderTick();
    }

    private List<MutableComponent> getDisplayTexts() {
        MutableComponent first = Component.empty();
        boolean hasInfo = false;
        List<Object> infos = List.of();
        Tuple<String, List<MutableComponent>> itemTagInfo = this.getItemTagInfo();
        TooltipKeyManager.PressState itemTagState = KEY_MANAGER.itemTag();
        if (itemTagInfo != null && itemTagState.show()) {
            hasInfo = true;
            if (itemTagState.showDetail()) {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), I18n.get((String)((String)itemTagInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.WHITE));
                infos = ((List)itemTagInfo.getB()).stream().map(x -> x.withStyle(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), I18n.get((String)((String)itemTagInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.GRAY));
            }
        }
        Tuple<String, List<MutableComponent>> specificInfo = this.getSpecificInfo();
        TooltipKeyManager.PressState specificState = KEY_MANAGER.specific();
        if (specificInfo != null && specificState.show()) {
            hasInfo = true;
            if (specificState.showDetail()) {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), I18n.get((String)((String)specificInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.WHITE));
                infos = ((List)specificInfo.getB()).stream().map(x -> x.withStyle(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), I18n.get((String)((String)specificInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.GRAY));
            }
        }
        Tuple<String, List<MutableComponent>> nbtInfo = this.getNbtInfo();
        TooltipKeyManager.PressState nbtState = KEY_MANAGER.nbt();
        if (nbtInfo != null && nbtState.show()) {
            hasInfo = true;
            if (nbtState.showDetail()) {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), I18n.get((String)((String)nbtInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.WHITE));
                infos = ((List)nbtInfo.getB()).stream().map(x -> x.withStyle(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.append((Component)Component.literal((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), I18n.get((String)((String)nbtInfo.getA()), (Object[])new Object[0]))).withStyle(ChatFormatting.GRAY));
            }
        }
        return hasInfo ? ImmutableList.builder().add((Object)first).addAll(infos).build() : List.of();
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getItemTagInfo() {
        if (!this.itemTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.item_tags", this.itemTags.stream().map(Component::literal).toList());
        }
        return null;
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getSpecificInfo() {
        if (!this.blockTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.block_tags", this.blockTags.stream().map(Component::literal).toList());
        }
        if (!this.entityTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.entity_tags", this.entityTags.stream().map(Component::literal).toList());
        }
        if (this.lootTable != null && this.lootTable.left() != null) {
            return new Tuple((Object)"tooltip.tooltips_reforged.loot_table", List.of(Component.literal((String)("tooltip.tooltips_reforged.id" + ((ResourceLocation)this.lootTable.left()).toString())), Component.literal((String)("tooltip.tooltips_reforged.seed" + this.lootTable.rightLong()))));
        }
        return null;
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getNbtInfo() {
        if (!this.entityInfo.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.mob_info", this.entityInfo);
        }
        if (!this.nbt.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.nbt", this.nbt);
        }
        return null;
    }
}

