/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.DurabilityRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.BadgesUtils;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DurabilityComponent
implements ClientTooltipComponent,
RenderHelper {
    private static final int WIDTH = 80;
    protected final ItemStack stack;
    private final DurabilityRenderMode mode;
    private final boolean enabled;
    private final int color;
    private final Component text;

    public DurabilityComponent(ItemStack stack) {
        this.stack = stack;
        this.mode = (DurabilityRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.durabilityTooltip.getValue());
        this.enabled = this.mode.isEnabled() && this.stack.isDamageableItem() && this.stack.getMaxDamage() > 0;
        this.color = stack.getBarColor();
        this.text = this.enabled ? DurabilityComponent.getDurabilityText(stack, this.mode) : Component.literal((String)"");
    }

    private static Component getDurabilityText(ItemStack stack, DurabilityRenderMode mode) {
        int maxDamage = stack.getMaxDamage();
        int damaged = maxDamage - stack.getDamageValue();
        if (mode.shouldInPercentage() && maxDamage > 0) {
            MutableComponent percentageText = Component.literal((String)(" " + damaged * 100 / maxDamage + "%"));
            return mode.shouldColorText() ? (Component)percentageText.toFlatList(Style.EMPTY.withColor(stack.getBarColor())).getFirst() : percentageText;
        }
        return mode.shouldColorText() ? Component.literal((String)" ").append((Component)Component.literal((String)String.valueOf(damaged)).setStyle(Style.EMPTY.withColor(stack.getBarColor()))).append((Component)Component.literal((String)" / ").setStyle(Style.EMPTY.withColor(-8355712))).append((Component)Component.literal((String)String.valueOf(maxDamage)).setStyle(Style.EMPTY.withColor(-16711936))) : Component.literal((String)(" " + damaged + " / " + maxDamage));
    }

    public int getHeight() {
        return this.enabled ? (this.mode.shouldRenderBackground() ? 13 : 9) : 0;
    }

    public int getWidth(Font textRenderer) {
        if (!this.enabled) {
            return 0;
        }
        int width = textRenderer.width((FormattedText)Component.translatable((String)"tooltip.%s.durability".formatted("tooltips_reforged")));
        if (this.mode.shouldRenderBackground()) {
            return width + 4 + 80 - 5;
        }
        return width + textRenderer.width((FormattedText)this.text);
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.enabled) {
            return;
        }
        boolean background = this.mode.shouldRenderBackground();
        if (background) {
            y += 2;
        }
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textY = background ? y - textHeight + 8 + 2 : y;
        MutableComponent durability = Component.translatable((String)"tooltip.%s.durability".formatted("tooltips_reforged"));
        context.drawString(textRenderer, (Component)durability, x, textY, -1, true);
        x += textRenderer.width((FormattedText)durability) + 4 - 4;
        int damaged = this.stack.getMaxDamage() - this.stack.getDamageValue();
        if (background) {
            int color = BadgesUtils.darkenColor(0xFF000000 | this.color, 0.9f);
            context.fill(x, textY - 2 + 1, x + damaged * 80 / this.stack.getMaxDamage(), textY + textHeight - 1, color);
            BadgesUtils.drawFrame(context, x, textY - 2 + 1, 80, textHeight + 4 - 2, 400, BadgesUtils.darkenColor(0xFF000000 | this.stack.getBarColor(), 0.8f));
        }
        int textX = background ? x + (80 - textRenderer.width((FormattedText)this.text)) / 2 - 1 : x - 4;
        context.drawString(textRenderer, this.text, textX, textY, -1, true);
    }
}

