/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentSortMode;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentsRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.RandomHelper;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchantmentsComponent
implements ClientTooltipComponent,
RenderHelper {
    private final List<EnchantmentInfo> enchantments = new LinkedList<EnchantmentInfo>();
    private final EnchantmentsRenderMode mode;
    private final boolean extraColor;

    public EnchantmentsComponent(ItemEnchantments component) {
        this.mode = (EnchantmentsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.enchantmentTooltip.getValue());
        for (Object2IntMap.Entry entry : component.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            String descriptionKey = String.valueOf(((Enchantment)enchantment.value()).description().copy()) + ".desc";
            Optional optional = enchantment.unwrapKey();
            if (optional.isEmpty()) continue;
            this.enchantments.add(new EnchantmentInfo((Holder<Enchantment>)enchantment, entry.getIntValue(), ((ResourceKey)optional.get()).location(), I18n.exists((String)descriptionKey) ? TextUtil.splitText(Component.literal((String)I18n.get((String)descriptionKey, (Object[])new Object[0])), 300, Minecraft.getInstance().font) : List.of()));
        }
        this.enchantments.sort(((EnchantmentSortMode)((Object)TooltipReforgedConfig.INSTANCE.misc.enchantmentSort.getValue())).getComparator());
        this.extraColor = (Boolean)TooltipReforgedConfig.INSTANCE.misc.advancedEnchantmentColor.getValue();
    }

    private static boolean isShiftDown() {
        long handle = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)handle, (int)340) || InputConstants.isKeyDown((long)handle, (int)344);
    }

    private boolean shouldDisplayDetail() {
        return this.mode.shouldAlwaysDescription() || EnchantmentsComponent.isShiftDown();
    }

    public int getHeight() {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> p + c.getHeight(includeDetail), Integer::sum) : 0;
    }

    public int getWidth(Font textRenderer) {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> Math.max(p, c.getWidth(textRenderer, includeDetail)), Math::max) : 0;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.mode.shouldRender()) {
            return;
        }
        int currentY = y;
        for (EnchantmentInfo info : this.enchantments) {
            int currentX = x;
            Component name = EnchantmentsComponent.getEnchantmentName(info.enchantment, info.level, this.extraColor);
            context.drawString(textRenderer, name, currentX, currentY, -1, true);
            this.drawStack(context, new ItemStack(RandomHelper.pick(((Enchantment)info.enchantment.value()).definition().supportedItems().stream().toList(), BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.AIR))), currentX += textRenderer.width((FormattedText)name) + 2, currentY, 10.0f);
            currentX += 12;
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                context.drawString(textRenderer, info.id.toString(), currentX, currentY, 0x555555, true);
            }
            currentY += 10;
            if (!this.shouldDisplayDetail()) continue;
            for (MutableComponent text : info.descriptions) {
                context.drawString(textRenderer, (Component)text.withStyle(ChatFormatting.DARK_GRAY), x, currentY, -1, true);
                currentY += 10;
            }
        }
    }

    private static Component getEnchantmentName(Holder<Enchantment> enchantment, int level, boolean extraColor) {
        MutableComponent mutableText = ((Enchantment)enchantment.value()).description().copy();
        if (enchantment.is(EnchantmentTags.CURSE)) {
            mutableText.withStyle(ChatFormatting.RED);
        } else if (extraColor && ((Enchantment)enchantment.value()).getMaxLevel() < level) {
            mutableText.withStyle(ChatFormatting.LIGHT_PURPLE);
        } else if (extraColor) {
            mutableText.withStyle(ChatFormatting.GREEN);
        } else {
            mutableText.withStyle(ChatFormatting.GRAY);
        }
        if (level != 1 || ((Enchantment)enchantment.value()).getMaxLevel() != 1) {
            mutableText.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + level))).append((Component)Component.literal((String)"/").append((Component)Component.translatable((String)("enchantment.level." + ((Enchantment)enchantment.value()).getMaxLevel()))).withStyle(ChatFormatting.DARK_GRAY));
        }
        return mutableText;
    }

    public record EnchantmentInfo(Holder<Enchantment> enchantment, int level, ResourceLocation id, List<MutableComponent> descriptions) {
        public int getWidth(Font textRenderer, boolean includeDetail) {
            int width = textRenderer.width((FormattedText)EnchantmentsComponent.getEnchantmentName(this.enchantment, this.level, false)) + 14 + (Minecraft.getInstance().options.advancedItemTooltips ? textRenderer.width(this.id.toString()) : 0);
            if (includeDetail) {
                for (MutableComponent text : this.descriptions) {
                    width = Math.max(width, textRenderer.width((FormattedText)text));
                }
            }
            return width;
        }

        public int getHeight(boolean includeDetail) {
            return 10 + (includeDetail ? this.descriptions.size() * 10 : 0);
        }
    }
}

