/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityViewerComponent
extends StandaloneComponent
implements RenderHelper {
    public static final Map<MobBucketItem, Supplier<? extends EntityType<?>>> ENTITY_BUCKET_MAP = new HashMap();
    private static final float ROTATION_INCREMENT = 0.2f;
    private static float CURRENT_ROTATION = 0.0f;
    private static final int ENTITY_OFFSET = 40;

    public EntityViewerComponent(ItemStack stack) {
        super(stack);
    }

    @Override
    public void render(GuiGraphics context, Font textRenderer, int x, int y, int z) {
        CURRENT_ROTATION = (CURRENT_ROTATION + 0.2f) % 360.0f;
        Item item = this.stack.getItem();
        if (item instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)item;
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bucketTooltip.getValue()).booleanValue()) {
                this.renderBucketEntity(context, x, y, z, bucketItem);
            }
        } else {
            item = this.stack.getItem();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.spawnEggTooltip.getValue()).booleanValue()) {
                    this.renderSpawnEggEntity(context, x, y, z, spawnEggItem);
                }
            }
        }
    }

    private void renderBucketEntity(GuiGraphics context, int x, int y, int z, MobBucketItem bucketItem) {
        if (!ENTITY_BUCKET_MAP.containsKey(bucketItem)) {
            return;
        }
        EntityType<?> entityType = ENTITY_BUCKET_MAP.get(bucketItem).get();
        Entity entity = entityType.create((Level)Minecraft.getInstance().level);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CompoundTag nbtComponent = ((CustomData)this.stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
                bucketable.loadFromBucketTag(nbtComponent);
                if (entityType == EntityType.TROPICAL_FISH) {
                    return;
                }
                if (bucketable instanceof Pufferfish) {
                    Pufferfish pufferfishEntity = (Pufferfish)bucketable;
                    pufferfishEntity.setPuffState(2);
                }
                this.renderBackground(context, x - 40 - 70, y, 80, 40, z);
                livingEntity.tick();
                this.drawEntity(context, x - 67, y + 40, 30, -CURRENT_ROTATION, livingEntity);
            }
        }
    }

    private void renderSpawnEggEntity(GuiGraphics context, int x, int y, int z, SpawnEggItem spawnEggItem) {
        CompoundTag nbt;
        EntityType entityType = spawnEggItem.getType(this.stack);
        Entity entity = entityType.create((Level)Minecraft.getInstance().level);
        if (entity == null) {
            return;
        }
        if (entityType == EntityType.VILLAGER || entityType == EntityType.ZOMBIE_VILLAGER) {
            CompoundTag villagerData = new CompoundTag();
            villagerData.putString("profession", "minecraft:none");
            villagerData.putString("type", "minecraft:plains");
            nbt = new CompoundTag();
            nbt.put("VillagerData", (Tag)villagerData);
            entity.load(nbt);
        }
        if (entityType == EntityType.TROPICAL_FISH) {
            return;
        }
        if (entity instanceof Pufferfish) {
            Pufferfish pufferfishEntity = (Pufferfish)entity;
            pufferfishEntity.setPuffState(2);
        }
        if (entity instanceof SnowGolem) {
            SnowGolem snowGolemEntity = (SnowGolem)entity;
            snowGolemEntity.setPumpkin(false);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            nbt = ((CustomData)this.stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (nbt != null) {
                livingEntity.readAdditionalSaveData(nbt);
            }
            this.renderBackground(context, x - 40 - 70, y, 80, 80, z);
            livingEntity.tick();
            this.drawEntity(context, x - 67, y + 75, 40, -CURRENT_ROTATION, livingEntity);
        }
    }
}

