/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.DurabilityComponent;
import com.iafenvoy.tooltipsreforged.component.EnchantmentsComponent;
import com.iafenvoy.tooltipsreforged.component.HeaderComponent;
import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.TooltipsRenderHelper;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EquipmentCompareComponent
extends StandaloneComponent {
    private final List<ClientTooltipComponent> components = new LinkedList<ClientTooltipComponent>();
    private final ItemStack equipped;

    public EquipmentCompareComponent(ItemStack stack) {
        super(stack);
        Item item;
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.equipmentCompareTooltip.getValue()).booleanValue() || !((item = this.stack.getItem()) instanceof Equipable)) {
            this.equipped = ItemStack.EMPTY;
            return;
        }
        Equipable equipment = (Equipable)item;
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        this.equipped = player.getItemBySlot(equipment.getEquipmentSlot());
        if (this.equipped.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.equipped, (ItemStack)this.stack)) {
            return;
        }
        for (Component text : this.equipped.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player, (TooltipFlag)TooltipFlag.NORMAL)) {
            if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.removeEmptyLines.getValue()).booleanValue() && ExtendedTextVisitor.getText(text.getVisualOrderText()).getString().isEmpty()) continue;
            this.components.add((ClientTooltipComponent)new ClientTextTooltip(text.getVisualOrderText()));
        }
        if (!this.components.isEmpty()) {
            this.components.removeFirst();
        }
        LinkedList<Object> headers = new LinkedList<Object>();
        headers.add(new ClientTextTooltip(Component.translatable((String)"tooltip.tooltips_reforged.currently_equipped").getVisualOrderText()));
        headers.add(new HeaderComponent(this.equipped));
        if (this.equipped.getItem().isEnchantable(this.equipped)) {
            headers.add(new EnchantmentsComponent(this.equipped.getEnchantments()));
        }
        this.components.addAll(0, headers);
        this.components.add(new DurabilityComponent(this.equipped));
    }

    @Override
    public void render(GuiGraphics context, Font textRenderer, int x, int y, int z) {
        if (this.components.isEmpty()) {
            return;
        }
        TooltipsRenderHelper.ResolveResult result = TooltipsRenderHelper.resolveTooltips(textRenderer, this.components);
        if (result.pages().isEmpty()) {
            return;
        }
        TooltipsRenderHelper.Page page = result.pages().getFirst();
        int height = page.getHeight();
        TooltipsRenderHelper.drawWithResult(result, this.equipped, context, textRenderer, x, y - height - 20);
    }
}

