/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FoodEffectComponent
implements ClientTooltipComponent {
    protected final ItemStack stack;
    private final EffectsRenderMode effectsMode;

    public FoodEffectComponent(ItemStack stack) {
        this.stack = stack;
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public FoodProperties getFoodComponent() {
        return (FoodProperties)this.stack.getOrDefault(DataComponents.FOOD, (Object)Foods.APPLE);
    }

    public int getHunger() {
        return this.getFoodComponent().nutrition();
    }

    public int getSaturation() {
        FoodProperties foodComponent = this.getFoodComponent();
        int saturation = 0;
        if (foodComponent != null) {
            saturation = (int)(foodComponent.saturation() * 100.0f);
        }
        return saturation;
    }

    public int getHeight() {
        int height = 0;
        FoodProperties foodComponent = this.getFoodComponent();
        if (foodComponent != null) {
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.nutrition() > 0) {
                height += 10;
            }
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.saturation() > 0.0f) {
                height += 10;
            }
            if (this.effectsMode.shouldRender()) {
                height += foodComponent.effects().size() * 10;
            }
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        int effectsWidth = 0;
        int hungerLine = 0;
        int saturationLine = 0;
        FoodProperties foodComponent = this.getFoodComponent();
        int hunger = this.getHunger();
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.nutrition() > 0) {
            int n = textRenderer.width((FormattedText)Component.translatable((String)"tooltip.%s.hunger".formatted("tooltips_reforged"))) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = n + (9 - 2) * hunger;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.saturation() > 0.0f) {
            saturationLine = textRenderer.width((FormattedText)Component.translatable((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{"100%"}));
        }
        int foodWidth = Math.max(hungerLine, saturationLine);
        if (!this.effectsMode.shouldRender()) {
            return foodWidth + 4;
        }
        if (foodComponent == null) {
            return 0;
        }
        for (FoodProperties.PossibleEffect effect : foodComponent.effects()) {
            MobEffectInstance statusEffect = effect.effect();
            Object text = Component.translatable((String)statusEffect.getDescriptionId()).getString();
            if (statusEffect.getAmplifier() > 0) {
                text = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{text, Component.translatable((String)("potion.potency." + statusEffect.getAmplifier())).getString()}).getString();
            }
            if (!statusEffect.endsWithin(20)) {
                text = (String)text + " " + TextUtil.getDurationText(statusEffect, 1.0f).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.width((String)text) + 14);
        }
        return Math.max(foodWidth, effectsWidth) + 4;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        FoodProperties foodComponent = this.getFoodComponent();
        if (foodComponent == null) {
            return;
        }
        int hunger = this.getHunger();
        MutableComponent hungerText = Component.translatable((String)"tooltip.%s.hunger".formatted("tooltips_reforged"));
        MutableComponent saturationText = Component.translatable((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{this.getSaturation()});
        int lineY = y;
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.nutrition() > 0) {
            context.drawString(textRenderer, (Component)hungerText, x, lineY, -1, true);
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.width((FormattedText)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blit(resourceLocation, x + hungerWidth, lineY, 52.0f, 27.0f, 9, 9, 256, 256);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blit(resourceLocation, x + hungerWidth, lineY, 61.0f, 27.0f, 9, 9, 256, 256);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.saturation() > 0.0f) {
            context.drawString(textRenderer, (Component)saturationText, x, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        for (FoodProperties.PossibleEffect effect : foodComponent.effects()) {
            MobEffectInstance statusEffect = effect.effect();
            int c = ((MobEffect)statusEffect.getEffect().value()).getColor();
            TextureAtlasSprite effectTexture = Minecraft.getInstance().getMobEffectTextures().get(statusEffect.getEffect());
            if (c == 0) {
                c = -11250436;
            }
            String effectName = Component.translatable((String)statusEffect.getDescriptionId()).getString();
            if (statusEffect.getAmplifier() > 0) {
                effectName = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.translatable((String)("potion.potency." + statusEffect.getAmplifier())).getString()}).getString();
            }
            Object fullText = effectName;
            if (!statusEffect.endsWithin(20)) {
                fullText = (String)fullText + " (" + TextUtil.getDurationText(statusEffect, 1.0f).getString() + ")";
            }
            MutableComponent renderText = Component.literal((String)fullText);
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blit(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.drawString(textRenderer, (Component)renderText, x + 9 + 2, lineY, c, true);
            } else {
                context.drawString(textRenderer, (Component)renderText, x, lineY, c, true);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
    }
}

