/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapComponent
implements ClientTooltipComponent {
    protected final ItemStack stack;

    public MapComponent(ItemStack stack) {
        this.stack = stack;
    }

    public int getHeight() {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.mapTooltip.getValue() != false ? 130 : 0;
    }

    public int getWidth(Font textRenderer) {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.mapTooltip.getValue() != false ? 128 : 0;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.mapTooltip.getValue()).booleanValue()) {
            return;
        }
        MultiBufferSource.BufferSource vertexConsumers = Minecraft.getInstance().renderBuffers().bufferSource();
        MapRenderer mapRenderer = Minecraft.getInstance().gameRenderer.getMapRenderer();
        MapId mapId = (MapId)this.stack.get(DataComponents.MAP_ID);
        MapItemSavedData mapState = MapItem.getSavedData((ItemStack)this.stack, (Level)Minecraft.getInstance().level);
        if (mapId == null || mapState == null) {
            return;
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 0.0f);
        matrices.scale(1.0f, 1.0f, 0.0f);
        mapRenderer.update(mapId, mapState);
        mapRenderer.render(matrices, (MultiBufferSource)vertexConsumers, mapId, mapState, false, 0xF000F0);
        matrices.popPose();
    }
}

