/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingComponent
implements ClientTooltipComponent {
    private final PaintingVariant variant;
    private final int width;
    private final int height;

    public PaintingComponent(ItemStack stack) {
        CompoundTag nbtCompound = ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        Painting painting = (Painting)EntityType.PAINTING.create((Level)Minecraft.getInstance().level);
        if (nbtCompound != null && painting != null) {
            painting.load(nbtCompound.copy());
            this.variant = (PaintingVariant)painting.getVariant().value();
            this.width = this.variant.width() * 2;
            this.height = this.variant.height() * 2;
        } else {
            this.variant = null;
            this.width = 0;
            this.height = 0;
        }
    }

    public int getHeight() {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.paintingTooltip.getValue() != false ? this.height : 0;
    }

    public int getWidth(Font textRenderer) {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.paintingTooltip.getValue() != false ? this.width : 0;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (this.variant == null || !((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.paintingTooltip.getValue()).booleanValue()) {
            return;
        }
        TextureAtlasSprite sprite = Minecraft.getInstance().getPaintingTextures().get(this.variant);
        context.blit(x, y, 0, this.width, this.height, sprite);
    }
}

