/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PotionEffectsComponent
implements ClientTooltipComponent {
    private final float durationMultiplier;
    private final List<MobEffectInstance> effects = new LinkedList<MobEffectInstance>();
    private final EffectsRenderMode effectsMode;

    public PotionEffectsComponent(ItemStack stack, float durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
        ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).forEachEffect(this.effects::add);
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public int getHeight() {
        return this.effects.size() * 10;
    }

    public int getWidth(Font textRenderer) {
        int effectsWidth = 0;
        for (MobEffectInstance effect : this.effects) {
            Object text = Component.translatable((String)effect.getDescriptionId()).getString();
            if (effect.getAmplifier() > 0) {
                text = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{text, Component.translatable((String)("potion.potency." + effect.getAmplifier())).getString()}).getString();
            }
            if (!effect.endsWithin(20)) {
                text = (String)text + " " + TextUtil.getDurationText(effect, this.durationMultiplier).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.width((String)text) + 14);
        }
        return effectsWidth + 4;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        Objects.requireNonNull(textRenderer);
        int lineY = y - 9 - 1;
        for (MobEffectInstance effect : this.effects) {
            int c = ((MobEffect)effect.getEffect().value()).getColor();
            if (c == 0) {
                c = -11250436;
            }
            TextureAtlasSprite effectTexture = Minecraft.getInstance().getMobEffectTextures().get(effect.getEffect());
            MutableComponent mutableText = Component.translatable((String)effect.getDescriptionId());
            if (effect.getAmplifier() > 0) {
                mutableText = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.translatable((String)("potion.potency." + effect.getAmplifier()))});
            }
            if (!effect.endsWithin(20)) {
                String durationText = TextUtil.getDurationText(effect, this.durationMultiplier).getString();
                mutableText = Component.literal((String)(mutableText.getString() + " (" + durationText + ")"));
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blit(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.drawString(textRenderer, (Component)mutableText, x + 9 + 2, lineY, c, true);
                continue;
            }
            context.drawString(textRenderer, (Component)mutableText, x, lineY, c, true);
        }
    }
}

