/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.config.mode;

import com.iafenvoy.jupiter.interfaces.IConfigEnumEntry;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum ItemDisplayMode implements IConfigEnumEntry
{
    NONE(false, false),
    HEADER(true, false),
    ZOOM(false, true),
    BOTH(true, true);

    private final boolean renderHeader;
    private final boolean renderZoom;

    private ItemDisplayMode(boolean renderHeader, boolean renderZoom) {
        this.renderHeader = renderHeader;
        this.renderZoom = renderZoom;
    }

    public boolean shouldRenderHeader() {
        return this.renderHeader;
    }

    public boolean shouldRenderZoom() {
        return this.renderZoom;
    }

    public Component getDisplayText() {
        return Component.translatable((String)"config.%s.header.item_display.%s".formatted("tooltips_reforged", this.name().toLowerCase(Locale.ROOT)));
    }

    public String getName() {
        return this.name();
    }

    @NotNull
    public IConfigEnumEntry getByName(String s) {
        return ItemDisplayMode.valueOf(s);
    }

    public IConfigEnumEntry cycle(boolean b) {
        ItemDisplayMode[] types = ItemDisplayMode.values();
        return types[(this.ordinal() + (b ? 1 : -1)) % types.length];
    }
}

