/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.hook;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.ApiStatus;

public final class RarityHook {
    private static final List<BiFunction<MutableComponent, Rarity, MutableComponent>> HOOKS = new LinkedList<BiFunction<MutableComponent, Rarity, MutableComponent>>();

    public static void register(BiFunction<MutableComponent, Rarity, MutableComponent> hook) {
        HOOKS.add(hook);
    }

    @ApiStatus.Internal
    public static MutableComponent applyColor(MutableComponent text, Rarity rarity) {
        return HOOKS.stream().collect(() -> text, (p, c) -> c.apply(p, rarity), MutableComponent::append);
    }

    static {
        RarityHook.register((text, rarity) -> text.withStyle(rarity.color() == ChatFormatting.BLACK ? ChatFormatting.WHITE : rarity.color()));
    }
}

