/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public interface RenderHelper {
    public static final int SPACING = 4;
    public static final int SHADOW_LIGHT_COLOR = 0xF000F0;

    default public void drawStack(GuiGraphics context, ItemStack stack, int x, int y, float size) {
        boolean bl;
        if (stack.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        BakedModel bakedModel = client.getItemRenderer().getModel(stack, (Level)client.level, (LivingEntity)client.player, 0);
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)x + size / 2.0f, (float)y + size / 2.0f, 150.0f);
        matrices.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.scale(size, size, size);
        boolean bl2 = bl = !bakedModel.usesBlockLight();
        if (bl) {
            Lighting.setupForFlatItems();
        }
        client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrices, (MultiBufferSource)context.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        context.flush();
        if (bl) {
            Lighting.setupFor3DItems();
        }
        matrices.popPose();
    }

    default public void drawEntity(GuiGraphics context, int centerX, int centerY, int maxSize, float rotationYaw, LivingEntity entity) {
        float pitch = entity.getXRot();
        float yaw = entity.getYRot();
        float bodyYaw = entity.yBodyRot;
        float headYaw = entity.yHeadRot;
        entity.setXRot(0.0f);
        entity.setYRot(rotationYaw);
        entity.yBodyRot = rotationYaw;
        entity.yHeadRot = rotationYaw;
        double boxX = entity.getBoundingBox().getXsize();
        double boxY = entity.getBoundingBox().getYsize();
        double scale = (boxX + boxY) / 2.0;
        Quaternionf correctionRotation = entity instanceof Cod || entity instanceof Salmon ? new Quaternionf().rotateZ((float)Math.toRadians(-90.0)) : new Quaternionf().rotateX((float)Math.toRadians(180.0));
        Quaternionf combinedRotation = new Quaternionf().rotateY((float)Math.toRadians(rotationYaw)).mul((Quaternionfc)correctionRotation);
        if (entity instanceof AbstractSchoolingFish) {
            centerY -= 20;
            scale *= 1.5;
        }
        this.drawEntity(context, (double)centerX - boxX / 2.0, (double)centerY - boxY / 2.0, (float)((double)maxSize / scale), combinedRotation, (Entity)entity);
        entity.setXRot(pitch);
        entity.setYRot(yaw);
        entity.yBodyRot = bodyYaw;
        entity.yHeadRot = headYaw;
    }

    default public void drawEntity(GuiGraphics context, double x, double y, float size, Quaternionf rotation, Entity entity) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate(x, y, 450.0);
        matrices.scale(-1.0f, 1.0f, 1.0f);
        matrices.mulPose(new Matrix4f().scaling(size, size, size));
        matrices.mulPose(rotation);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.setRenderShadow(false);
        dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.pose(), (MultiBufferSource)context.bufferSource(), 0xF000F0);
        dispatcher.setRenderShadow(true);
        matrices.popPose();
        Lighting.setupFor3DItems();
    }
}

