/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.hook.RarityHook;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipProviders {
    public static Component getRarityName(ItemStack stack) {
        return Component.translatable((String)"rarity.%s.%s".formatted("tooltips_reforged", stack.getRarity().name().toLowerCase())).setStyle(Style.EMPTY.withColor(-8355712));
    }

    public static Component getDisplayName(ItemStack stack) {
        return RarityHook.applyColor(Component.empty(), stack.getRarity()).append(stack.getHoverName());
    }

    public static int getItemBorderColor(ItemStack stack) {
        Integer color = null;
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.useNameColor.getValue()).booleanValue()) {
            color = TextUtil.getColorFromTranslation(TooltipProviders.getDisplayName(stack));
        }
        if (color == null || color == -1) {
            Rarity rarity = stack.getRarity();
            TextColor textColor = RarityHook.applyColor(Component.empty(), rarity).getStyle().getColor();
            if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.overwriteRarityColor.getValue()).booleanValue()) {
                if (rarity == Rarity.COMMON) {
                    textColor = TextColor.fromRgb((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.commonRarityColor.getValue()));
                } else if (rarity == Rarity.UNCOMMON) {
                    textColor = TextColor.fromRgb((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.uncommonRarityColor.getValue()));
                } else if (rarity == Rarity.RARE) {
                    textColor = TextColor.fromRgb((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.rareRarityColor.getValue()));
                } else if (rarity == Rarity.EPIC) {
                    textColor = TextColor.fromRgb((int)((Integer)TooltipReforgedConfig.INSTANCE.misc.epicRarityColor.getValue()));
                }
            }
            if ((color = textColor != null ? Integer.valueOf(textColor.getValue()) : rarity.color().getColor()) == null || color == 0xFFFFFF) {
                color = -1;
            }
        }
        return color;
    }
}

