/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ComponentsProcessor {
    public static final List<String> DEFAULT_IGNORED = List.of("minecraft:max_stack_size", "minecraft:rarity");

    public static List<MutableComponent> processStack(ItemStack stack, RegistryAccess registries) {
        List ignored = (List)TooltipReforgedConfig.INSTANCE.misc.ignoredComponents.getValue();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataComponentType type : stack.getComponents().keySet()) {
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)type);
            if (id != null && ignored.contains(id.toString())) continue;
            builder.addAll(ComponentsProcessor.processSingle(id, ComponentsProcessor.serialize(type, stack, registries)));
        }
        return builder.build();
    }

    private static <T> String serialize(DataComponentType<T> type, ItemStack stack, RegistryAccess registries) {
        return ((JsonElement)type.codecOrThrow().encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries), stack.get(type)).resultOrPartial().orElse(new JsonObject())).toString();
    }

    public static List<MutableComponent> processSingle(@Nullable ResourceLocation id, String json) {
        MutableComponent mutableText;
        Pattern p = Pattern.compile("[{}:\"\\[\\],']", 2);
        MutableComponent mutableComponent = mutableText = id == null ? Component.empty() : Component.empty().append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY)).append(" ");
        if (!p.asPredicate().test(json)) {
            return List.of(mutableText.append((Component)Component.literal((String)json).withStyle(ChatFormatting.WHITE)));
        }
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        Matcher m = p.matcher(json);
        int lineStep = 50;
        ChatFormatting stringColour = ChatFormatting.GREEN;
        ChatFormatting quotationColour = ChatFormatting.DARK_GRAY;
        ChatFormatting separationColour = ChatFormatting.DARK_GRAY;
        ChatFormatting integerColour = ChatFormatting.GOLD;
        ChatFormatting typeColour = ChatFormatting.RED;
        ChatFormatting fieldColour = ChatFormatting.AQUA;
        ChatFormatting lstringColour = ChatFormatting.YELLOW;
        int lineLimit = lineStep;
        int removedCharters = 0;
        int lastIndex = 0;
        Boolean singleQuotationMark = Boolean.FALSE;
        Boolean lineAdded = Boolean.FALSE;
        String lastString = "";
        while (m.find()) {
            lineAdded = Boolean.FALSE;
            if (json.charAt(m.start()) == '\'') {
                if (singleQuotationMark.equals(Boolean.FALSE)) {
                    mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(quotationColour));
                    singleQuotationMark = Boolean.TRUE;
                } else {
                    mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start())).withStyle(stringColour));
                    mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(quotationColour));
                    singleQuotationMark = Boolean.FALSE;
                }
                lastString = String.valueOf(json.charAt(m.start()));
                lastIndex = m.start();
            }
            if (!singleQuotationMark.booleanValue()) {
                if (json.charAt(m.start()) == '{' || json.charAt(m.start()) == '[') {
                    mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(separationColour));
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == '}' || json.charAt(m.start()) == ']' || json.charAt(m.start()) == ',') {
                    if (json.charAt(m.start() - 1) == 's' || json.charAt(m.start() - 1) == 'S' || json.charAt(m.start() - 1) == 'b' || json.charAt(m.start() - 1) == 'B' || json.charAt(m.start() - 1) == 'l' || json.charAt(m.start() - 1) == 'L' || json.charAt(m.start() - 1) == 'f' || json.charAt(m.start() - 1) == 'F') {
                        mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start() - 1)).withStyle(integerColour));
                        mutableText.append((Component)Component.literal((String)json.substring(m.start() - 1, m.start())).withStyle(typeColour));
                    } else {
                        mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start())).withStyle(integerColour));
                    }
                    mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start())))).withStyle(separationColour);
                    if (json.charAt(m.start()) == ',') {
                        mutableText.append((Component)Component.literal((String)" ").withStyle(separationColour));
                    }
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == ':' && !lastString.equals("\"")) {
                    mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start())).withStyle(fieldColour));
                    mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(separationColour));
                    mutableText.append((Component)Component.literal((String)" ").withStyle(separationColour));
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == '\"') {
                    if (lastString.equals("\"")) {
                        if (m.start() - lineLimit > lineStep) {
                            mutableText.append((Component)Component.literal((String)"....").withStyle(lstringColour));
                            removedCharters += m.start() - lineLimit;
                        } else {
                            mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start())).withStyle(stringColour));
                        }
                        mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(quotationColour));
                    } else {
                        mutableText.append((Component)Component.literal((String)String.valueOf(json.charAt(m.start()))).withStyle(quotationColour));
                    }
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
            }
            if (m.start() - removedCharters < lineLimit || json.charAt(m.start()) != '}' && json.charAt(m.start()) != ']' && json.charAt(m.start()) != ',') continue;
            if (lastString.equals("'")) {
                mutableText.append((Component)Component.literal((String)json.substring(lastIndex + 1, m.start())).withStyle(stringColour));
                lastIndex = m.start();
            }
            list.add(mutableText);
            mutableText = Component.literal((String)"     ");
            lineAdded = Boolean.TRUE;
            lineLimit += lineStep;
        }
        if (lineAdded.equals(Boolean.FALSE)) {
            list.add(mutableText);
        }
        return list;
    }
}

