/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.util.ComponentsProcessor;
import it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class InfoCollectHelper {
    private static final List<Holder<Attribute>> ATTRIBUTES = List.of(Attributes.MAX_HEALTH, Attributes.MOVEMENT_SPEED, Attributes.ATTACK_DAMAGE, Attributes.ARMOR, Attributes.FOLLOW_RANGE, Attributes.KNOCKBACK_RESISTANCE, Attributes.ATTACK_KNOCKBACK);

    public static List<String> collectItemTags(ItemStack stack) {
        return BuiltInRegistries.ITEM.wrapAsHolder((Object)stack.getItem()).tags().map(TagKey::location).map(x -> "#" + x.toString()).toList();
    }

    public static List<String> collectBlockTags(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return BuiltInRegistries.BLOCK.wrapAsHolder((Object)blockItem.getBlock()).tags().map(TagKey::location).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<String> collectEntityTags(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem eggItem = (SpawnEggItem)item;
            return BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)eggItem.getType(stack)).tags().map(TagKey::location).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<MutableComponent> collectEntityInfo(ItemStack stack) {
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        ClientLevel world = Minecraft.getInstance().level;
        Item item = stack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem eggItem = (SpawnEggItem)item;
            if (world != null && (item = eggItem.getType(stack).create((Level)world)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)item;
                DecimalFormat df = new DecimalFormat("#.##");
                ATTRIBUTES.forEach(attribute -> {
                    AttributeInstance instance = living.getAttribute(attribute);
                    if (instance != null) {
                        list.add(Component.translatable((String)((Attribute)attribute.value()).getDescriptionId()).append(": ").append(df.format(instance.getValue())).withStyle(ChatFormatting.GRAY));
                    }
                });
                list.add(Component.translatable((String)"text.tooltips_reforged.mob_type").append((Component)Component.translatable((String)InfoCollectHelper.getMobType(living.getType()))).withStyle(ChatFormatting.GRAY));
            }
        }
        return list;
    }

    public static List<MutableComponent> collectNbt(ItemStack stack, RegistryAccess registries) {
        return ComponentsProcessor.processStack(stack, registries);
    }

    private static String getMobType(EntityType<?> type) {
        if (type.is(EntityTypeTags.UNDEAD)) {
            return "type.tooltips_reforged.undead";
        }
        if (type.is(EntityTypeTags.ARTHROPOD)) {
            return "type.tooltips_reforged.arthropod";
        }
        if (type.is(EntityTypeTags.ILLAGER)) {
            return "type.tooltips_reforged.illager";
        }
        if (type.is(EntityTypeTags.AQUATIC)) {
            return "type.tooltips_reforged.aquatic";
        }
        return "type.tooltips_reforged.default";
    }

    @Nullable
    public static ObjectLongPair<ResourceLocation> collectLootTable(ItemStack stack) {
        CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt != null && nbt.contains("LootTable", 8)) {
            return new ObjectLongImmutablePair((Object)ResourceLocation.tryParse((String)nbt.getString("LootTable")), nbt.getLong("LootTableSeed"));
        }
        return null;
    }

    @Nullable
    public static NonNullList<ItemStack> collectContainer(ItemStack stack, HolderLookup.Provider registries) {
        NonNullList stacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt == null || !nbt.contains("Items", 9)) {
            return null;
        }
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)stacks, (HolderLookup.Provider)registries);
        return stacks;
    }
}

