/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.google.common.collect.Lists;
import com.iafenvoy.tooltipsreforged.mixin.OrderedTextTooltipComponentAccessor;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextUtil {
    public static FormattedCharSequence getTextFromComponent(ClientTextTooltip component) {
        return ((OrderedTextTooltipComponentAccessor)component).getText();
    }

    public static List<MutableComponent> splitText(MutableComponent text, int chatWidth, Font fontRenderer) {
        int i = 0;
        MutableComponent ichatcomponent = Component.literal((String)"");
        ArrayList list = Lists.newArrayList();
        ArrayList chatComponents = Lists.newArrayList((Object[])new MutableComponent[]{text});
        for (int j = 0; j < chatComponents.size(); ++j) {
            MutableComponent currentChatComponent = (MutableComponent)chatComponents.get(j);
            String unformattedText = ExtendedTextVisitor.getString((Component)currentChatComponent);
            boolean addToList = false;
            if (unformattedText.contains("\n")) {
                int k = unformattedText.indexOf(10);
                String s1 = unformattedText.substring(k + 1);
                unformattedText = unformattedText.substring(0, k + 1);
                MutableComponent chatcomponenttext = Component.literal((String)(TextUtil.getColorCode(unformattedText) + s1));
                chatcomponenttext.setStyle(currentChatComponent.getStyle());
                chatComponents.add(j + 1, chatcomponenttext);
                addToList = true;
            }
            String textRemovedLastNewline = unformattedText.endsWith("\n") ? unformattedText.substring(0, unformattedText.length() - 1) : unformattedText;
            int textWidth = fontRenderer.width(textRemovedLastNewline);
            MutableComponent newChatComponent = Component.literal((String)textRemovedLastNewline);
            newChatComponent.setStyle(currentChatComponent.getStyle());
            if (i + textWidth > chatWidth) {
                String s3;
                String s2 = fontRenderer.plainSubstrByWidth(unformattedText, chatWidth - i, false);
                String string = s3 = s2.length() < unformattedText.length() ? unformattedText.substring(s2.length()) : null;
                if (s3 != null) {
                    int l = s2.lastIndexOf(" ");
                    if (l >= 0 && fontRenderer.width(unformattedText.substring(0, l)) > 0) {
                        s2 = unformattedText.substring(0, l);
                        s3 = unformattedText.substring(l);
                    } else if (i > 0 && !unformattedText.contains(" ")) {
                        s2 = "";
                        s3 = unformattedText;
                    }
                    MutableComponent chatcomponenttext2 = Component.literal((String)(TextUtil.getColorCode(s2) + s3));
                    chatcomponenttext2.setStyle(currentChatComponent.getStyle());
                    chatComponents.add(j + 1, chatcomponenttext2);
                }
                textWidth = fontRenderer.width(s2);
                newChatComponent = Component.literal((String)s2);
                newChatComponent.setStyle(currentChatComponent.getStyle());
                addToList = true;
            }
            if (i + textWidth <= chatWidth) {
                i += textWidth;
                ichatcomponent.append((Component)newChatComponent);
            } else {
                addToList = true;
            }
            if (!addToList) continue;
            list.add(ichatcomponent);
            i = 0;
            ichatcomponent = Component.literal((String)"");
        }
        list.add(ichatcomponent);
        return list;
    }

    public static String getColorCode(String s) {
        Object color = "";
        StringBuilder format = new StringBuilder();
        char last = '\u0000';
        for (char c : s.toCharArray()) {
            if (last == '\u00a7') {
                if (c == 'r' || '0' <= c && c <= 'f') {
                    color = "\u00a7" + c;
                    format = new StringBuilder();
                } else if ('k' <= c && c <= 'o') {
                    format.append("\u00a7").append(c);
                }
            }
            last = c;
        }
        return (String)color + String.valueOf(format);
    }

    public static int getColorFromTranslation(Component text) {
        return TextUtil.getColorFromTranslation(text.getString());
    }

    public static int getColorFromTranslation(String text) {
        char[] charArray = text.toCharArray();
        if (charArray.length < 2) {
            return -1;
        }
        for (int i = 0; i < charArray.length - 1; ++i) {
            int color;
            if (charArray[i] != '\u00a7') continue;
            ChatFormatting formatting = ChatFormatting.getByCode((char)charArray[i + 1]);
            int n = color = formatting == null ? -1 : Objects.requireNonNullElse(formatting.getColor(), -1);
            if (color == -1) continue;
            return color;
        }
        return -1;
    }

    public static Component getDurationText(MobEffectInstance effect, float multiplier) {
        if (effect.isInfiniteDuration() || effect.getDuration() >= 72000) {
            return Component.translatable((String)"effect.duration.infinite");
        }
        int i = Mth.floor((float)((float)effect.getDuration() * multiplier));
        return Component.literal((String)StringUtil.formatTickDuration((int)i, (float)20.0f));
    }
}

