/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.DurabilityRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.BadgesUtils;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

@Environment(value=EnvType.CLIENT)
public class DurabilityComponent
implements class_5684,
RenderHelper {
    private static final int WIDTH = 80;
    protected final class_1799 stack;
    private final DurabilityRenderMode mode;
    private final boolean enabled;
    private final int color;
    private final class_2561 text;

    public DurabilityComponent(class_1799 stack) {
        this.stack = stack;
        this.mode = (DurabilityRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.durabilityTooltip.getValue());
        this.enabled = this.mode.isEnabled() && this.stack.method_7963() && this.stack.method_7936() > 0;
        this.color = stack.method_31580();
        this.text = this.enabled ? DurabilityComponent.getDurabilityText(stack, this.mode) : class_2561.method_43470((String)"");
    }

    private static class_2561 getDurabilityText(class_1799 stack, DurabilityRenderMode mode) {
        int maxDamage = stack.method_7936();
        int damaged = maxDamage - stack.method_7919();
        if (mode.shouldInPercentage() && maxDamage > 0) {
            class_5250 percentageText = class_2561.method_43470((String)(" " + damaged * 100 / maxDamage + "%"));
            return mode.shouldColorText() ? (class_2561)percentageText.method_36136(class_2583.field_24360.method_36139(stack.method_31580())).get(0) : percentageText;
        }
        return mode.shouldColorText() ? class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(damaged)).method_10862(class_2583.field_24360.method_36139(stack.method_31580()))).method_10852((class_2561)class_2561.method_43470((String)" / ").method_10862(class_2583.field_24360.method_36139(-8355712))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(maxDamage)).method_10862(class_2583.field_24360.method_36139(-16711936))) : class_2561.method_43470((String)(" " + damaged + " / " + maxDamage));
    }

    public int method_32661() {
        return this.enabled ? (this.mode.shouldRenderBackground() ? 13 : 9) : 0;
    }

    public int method_32664(class_327 textRenderer) {
        if (!this.enabled) {
            return 0;
        }
        int width = textRenderer.method_27525((class_5348)class_2561.method_43471((String)"tooltip.%s.durability".formatted("tooltips_reforged")));
        if (this.mode.shouldRenderBackground()) {
            return width + 4 + 80 - 5;
        }
        return width + textRenderer.method_27525((class_5348)this.text);
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        if (!this.enabled) {
            return;
        }
        boolean background = this.mode.shouldRenderBackground();
        if (background) {
            y += 2;
        }
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textY = background ? y - textHeight + 8 + 2 : y;
        class_5250 durability = class_2561.method_43471((String)"tooltip.%s.durability".formatted("tooltips_reforged"));
        context.method_51439(textRenderer, (class_2561)durability, x, textY, -1, true);
        x += textRenderer.method_27525((class_5348)durability) + 4 - 4;
        int damaged = this.stack.method_7936() - this.stack.method_7919();
        if (background) {
            int color = BadgesUtils.darkenColor(0xFF000000 | this.color, 0.9f);
            context.method_25294(x, textY - 2 + 1, x + damaged * 80 / this.stack.method_7936(), textY + textHeight - 1, color);
            BadgesUtils.drawFrame(context, x, textY - 2 + 1, 80, textHeight + 4 - 2, 400, BadgesUtils.darkenColor(0xFF000000 | this.stack.method_31580(), 0.8f));
        }
        int textX = background ? x + (80 - textRenderer.method_27525((class_5348)this.text)) / 2 - 1 : x - 4;
        context.method_51439(textRenderer, this.text, textX, textY, -1, true);
    }
}

