/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentSortMode;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentsRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.InfoCollectHelper;
import com.iafenvoy.tooltipsreforged.util.RandomHelper;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class EnchantmentsComponent
implements class_5684,
RenderHelper {
    private final List<EnchantmentInfo> enchantments = new LinkedList<EnchantmentInfo>();
    private final EnchantmentsRenderMode mode;
    private final boolean extraColor;

    public EnchantmentsComponent(class_2499 list) {
        this(class_1890.method_22445((class_2499)list));
    }

    public EnchantmentsComponent(Map<class_1887, Integer> map) {
        this.mode = (EnchantmentsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.enchantmentTooltip.getValue());
        for (Map.Entry<class_1887, Integer> entry : map.entrySet()) {
            class_1887 enchantment = entry.getKey();
            String descriptionKey = enchantment.method_8184() + ".desc";
            this.enchantments.add(new EnchantmentInfo(enchantment, entry.getValue(), class_1074.method_4663((String)descriptionKey) ? TextUtil.splitText(class_2561.method_43470((String)class_1074.method_4662((String)descriptionKey, (Object[])new Object[0])), 300, class_310.method_1551().field_1772) : List.of()));
        }
        this.enchantments.sort(((EnchantmentSortMode)((Object)TooltipReforgedConfig.INSTANCE.misc.enchantmentSort.getValue())).getComparator());
        this.extraColor = (Boolean)TooltipReforgedConfig.INSTANCE.misc.advancedEnchantmentColor.getValue();
    }

    private static boolean isShiftDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)handle, (int)340) || class_3675.method_15987((long)handle, (int)344);
    }

    private boolean shouldDisplayDetail() {
        return this.mode.shouldAlwaysDescription() || EnchantmentsComponent.isShiftDown();
    }

    public int method_32661() {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> p + c.getHeight(includeDetail), Integer::sum) : 0;
    }

    public int method_32664(class_327 textRenderer) {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> Math.max(p, c.getWidth(textRenderer, includeDetail)), Math::max) : 0;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        if (!this.mode.shouldRender()) {
            return;
        }
        int currentY = y;
        for (EnchantmentInfo info : this.enchantments) {
            int currentX = x;
            class_2561 name = EnchantmentsComponent.getEnchantmentName(info.enchantment, info.level, this.extraColor);
            context.method_51439(textRenderer, name, currentX, currentY, -1, true);
            this.drawStack(context, new class_1799((class_1935)RandomHelper.pick(InfoCollectHelper.getEnchantmentTarget(info.enchantment.field_9083), class_1802.field_8162)), currentX += textRenderer.method_27525((class_5348)name) + 2, currentY, 10.0f);
            currentX += 12;
            if (class_310.method_1551().field_1690.field_1827) {
                context.method_51433(textRenderer, info.id.toString(), currentX, currentY, 0x555555, true);
            }
            currentY += 10;
            if (!this.shouldDisplayDetail()) continue;
            for (class_5250 text : info.descriptions) {
                context.method_51439(textRenderer, (class_2561)text.method_27692(class_124.field_1063), x, currentY, -1, true);
                currentY += 10;
            }
        }
    }

    private static class_2561 getEnchantmentName(class_1887 enchantment, int level, boolean extraColor) {
        class_5250 mutableText = class_2561.method_43471((String)enchantment.method_8184());
        if (enchantment.method_8195()) {
            mutableText.method_27692(class_124.field_1061);
        } else if (extraColor && enchantment.method_8183() < level) {
            mutableText.method_27692(class_124.field_1076);
        } else if (extraColor) {
            mutableText.method_27692(class_124.field_1060);
        } else {
            mutableText.method_27692(class_124.field_1080);
        }
        if (level != 1 || enchantment.method_8183() != 1) {
            mutableText.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level))).method_10852((class_2561)class_2561.method_43470((String)"/").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + enchantment.method_8183()))).method_27692(class_124.field_1063));
        }
        return mutableText;
    }

    public record EnchantmentInfo(class_1887 enchantment, int level, class_2960 id, List<class_5250> descriptions) {
        public EnchantmentInfo(class_1887 enchantment, int level, List<class_5250> description) {
            this(enchantment, level, Objects.requireNonNullElse(class_7923.field_41176.method_10221((Object)enchantment), class_2960.method_43902((String)"", (String)"")), description);
        }

        public int getWidth(class_327 textRenderer, boolean includeDetail) {
            int width = textRenderer.method_27525((class_5348)EnchantmentsComponent.getEnchantmentName(this.enchantment, this.level, false)) + 14 + (class_310.method_1551().field_1690.field_1827 ? textRenderer.method_1727(this.id.toString()) : 0);
            if (includeDetail) {
                for (class_5250 text : this.descriptions) {
                    width = Math.max(width, textRenderer.method_27525((class_5348)text));
                }
            }
            return width;
        }

        public int getHeight(boolean includeDetail) {
            return 10 + (includeDetail ? this.descriptions.size() * 10 : 0);
        }
    }
}

