/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.TooltipReforgedClient;
import com.iafenvoy.tooltipsreforged.util.NbtProcessor;
import it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1886;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class InfoCollectHelper {
    private static final List<class_1320> ATTRIBUTES = List.of(class_5134.field_23716, class_5134.field_23719, class_5134.field_23721, class_5134.field_23724, class_5134.field_23717, class_5134.field_23718, class_5134.field_23722);
    private static final Map<class_1886, List<class_1792>> TARGET_ITEMS_MAP = new HashMap<class_1886, List<class_1792>>();

    public static List<String> collectItemTags(class_1799 stack) {
        return class_7923.field_41178.method_47983((Object)stack.method_7909()).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
    }

    public static List<String> collectBlockTags(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return class_7923.field_41175.method_47983((Object)blockItem.method_7711()).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<String> collectEntityTags(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 eggItem = (class_1826)class_17922;
            return class_7923.field_41177.method_47983((Object)eggItem.method_8015(stack.method_7969())).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<class_5250> collectEntityInfo(class_1799 stack) {
        LinkedList<class_5250> list = new LinkedList<class_5250>();
        class_638 world = class_310.method_1551().field_1687;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 eggItem = (class_1826)class_17922;
            if (world != null && (class_17922 = eggItem.method_8015(stack.method_7969()).method_5883((class_1937)world)) instanceof class_1309) {
                class_1309 living = (class_1309)class_17922;
                DecimalFormat df = new DecimalFormat("#.##");
                ATTRIBUTES.forEach(attribute -> {
                    class_1324 instance = living.method_5996(attribute);
                    if (instance != null) {
                        list.add(class_2561.method_43471((String)attribute.method_26830()).method_27693(": ").method_27693(df.format(instance.method_6194())).method_27692(class_124.field_1080));
                    }
                });
                list.add(class_2561.method_43471((String)"text.tooltips_reforged.mob_type").method_10852((class_2561)class_2561.method_43471((String)InfoCollectHelper.getMobType(living.method_6046()))).method_27692(class_124.field_1080));
            }
        }
        return list;
    }

    public static List<class_5250> collectNbt(class_1799 stack) {
        return NbtProcessor.process(stack);
    }

    private static String getMobType(class_1310 type) {
        if (type == class_1310.field_6290) {
            return "type.tooltips_reforged.default";
        }
        if (type == class_1310.field_6289) {
            return "type.tooltips_reforged.undead";
        }
        if (type == class_1310.field_6293) {
            return "type.tooltips_reforged.arthropod";
        }
        if (type == class_1310.field_6291) {
            return "type.tooltips_reforged.illager";
        }
        if (type == class_1310.field_6292) {
            return "type.tooltips_reforged.aquatic";
        }
        return "";
    }

    @Nullable
    public static ObjectLongPair<class_2960> collectLootTable(class_1799 stack) {
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt != null && nbt.method_10573("LootTable", 8)) {
            return new ObjectLongImmutablePair((Object)class_2960.method_12829((String)nbt.method_10558("LootTable")), nbt.method_10537("LootTableSeed"));
        }
        return null;
    }

    public static List<class_1792> getEnchantmentTarget(class_1886 target) {
        return TARGET_ITEMS_MAP.getOrDefault(target, List.of());
    }

    @Nullable
    public static class_2371<class_1799> collectContainer(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null || !nbt.method_10573("Items", 9)) {
            return null;
        }
        class_1262.method_5429((class_2487)nbt, (class_2371)stacks);
        return stacks;
    }

    static {
        for (class_1886 target : class_1886.values()) {
            try {
                TARGET_ITEMS_MAP.put(target, class_7923.field_41178.method_10220().filter(arg_0 -> ((class_1886)target).method_8177(arg_0)).toList());
            }
            catch (Throwable e) {
                TooltipReforgedClient.LOGGER.error("Failed to load items for enchantment target {}", (Object)target.name(), (Object)e);
            }
        }
    }
}

