/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.google.common.collect.Lists;
import com.iafenvoy.tooltipsreforged.mixin.OrderedTextTooltipComponentAccessor;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5683;

@Environment(value=EnvType.CLIENT)
public final class TextUtil {
    public static class_5481 getTextFromComponent(class_5683 component) {
        return ((OrderedTextTooltipComponentAccessor)component).getText();
    }

    public static List<class_5250> splitText(class_5250 text, int chatWidth, class_327 fontRenderer) {
        int i = 0;
        class_5250 ichatcomponent = class_2561.method_43470((String)"");
        ArrayList list = Lists.newArrayList();
        ArrayList chatComponents = Lists.newArrayList((Object[])new class_5250[]{text});
        for (int j = 0; j < chatComponents.size(); ++j) {
            class_5250 currentChatComponent = (class_5250)chatComponents.get(j);
            String unformattedText = ExtendedTextVisitor.getString((class_2561)currentChatComponent);
            boolean addToList = false;
            if (unformattedText.contains("\n")) {
                int k = unformattedText.indexOf(10);
                String s1 = unformattedText.substring(k + 1);
                unformattedText = unformattedText.substring(0, k + 1);
                class_5250 chatcomponenttext = class_2561.method_43470((String)(TextUtil.getColorCode(unformattedText) + s1));
                chatcomponenttext.method_10862(currentChatComponent.method_10866());
                chatComponents.add(j + 1, chatcomponenttext);
                addToList = true;
            }
            String textRemovedLastNewline = unformattedText.endsWith("\n") ? unformattedText.substring(0, unformattedText.length() - 1) : unformattedText;
            int textWidth = fontRenderer.method_1727(textRemovedLastNewline);
            class_5250 newChatComponent = class_2561.method_43470((String)textRemovedLastNewline);
            newChatComponent.method_10862(currentChatComponent.method_10866());
            if (i + textWidth > chatWidth) {
                String s3;
                String s2 = fontRenderer.method_27524(unformattedText, chatWidth - i, false);
                String string = s3 = s2.length() < unformattedText.length() ? unformattedText.substring(s2.length()) : null;
                if (s3 != null) {
                    int l = s2.lastIndexOf(" ");
                    if (l >= 0 && fontRenderer.method_1727(unformattedText.substring(0, l)) > 0) {
                        s2 = unformattedText.substring(0, l);
                        s3 = unformattedText.substring(l);
                    } else if (i > 0 && !unformattedText.contains(" ")) {
                        s2 = "";
                        s3 = unformattedText;
                    }
                    class_5250 chatcomponenttext2 = class_2561.method_43470((String)(TextUtil.getColorCode(s2) + s3));
                    chatcomponenttext2.method_10862(currentChatComponent.method_10866());
                    chatComponents.add(j + 1, chatcomponenttext2);
                }
                textWidth = fontRenderer.method_1727(s2);
                newChatComponent = class_2561.method_43470((String)s2);
                newChatComponent.method_10862(currentChatComponent.method_10866());
                addToList = true;
            }
            if (i + textWidth <= chatWidth) {
                i += textWidth;
                ichatcomponent.method_10852((class_2561)newChatComponent);
            } else {
                addToList = true;
            }
            if (!addToList) continue;
            list.add(ichatcomponent);
            i = 0;
            ichatcomponent = class_2561.method_43470((String)"");
        }
        list.add(ichatcomponent);
        return list;
    }

    public static String getColorCode(String s) {
        Object color = "";
        StringBuilder format = new StringBuilder();
        char last = '\u0000';
        for (char c : s.toCharArray()) {
            if (last == '\u00a7') {
                if (c == 'r' || '0' <= c && c <= 'f') {
                    color = "\u00a7" + c;
                    format = new StringBuilder();
                } else if ('k' <= c && c <= 'o') {
                    format.append("\u00a7").append(c);
                }
            }
            last = c;
        }
        return (String)color + String.valueOf(format);
    }

    public static int getColorFromTranslation(class_2561 text) {
        return TextUtil.getColorFromTranslation(text.getString());
    }

    public static int getColorFromTranslation(String text) {
        char[] charArray = text.toCharArray();
        if (charArray.length < 2) {
            return -1;
        }
        for (int i = 0; i < charArray.length - 1; ++i) {
            int color;
            if (charArray[i] != '\u00a7') continue;
            class_124 formatting = class_124.method_544((char)charArray[i + 1]);
            int n = color = formatting == null ? -1 : Objects.requireNonNullElse(formatting.method_532(), -1);
            if (color == -1) continue;
            return color;
        }
        return -1;
    }

    public static class_2561 getDurationText(class_1293 effect, float multiplier) {
        if (effect.method_48559() || effect.method_5584() >= 72000) {
            return class_2561.method_43471((String)"effect.duration.infinite");
        }
        int i = class_3532.method_15375((float)((float)effect.method_5584() * multiplier));
        return class_2561.method_43470((String)class_3544.method_15439((int)i));
    }
}

