/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.mixin.KeyBindingAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class TooltipKeyManager {
    private static final String CATEGORY = "category.%s.keys".formatted("tooltips_reforged");
    public static final class_304 SHOW_SPECIFIC_INFO = new class_304("keybinding.%s.show_specific_info".formatted("tooltips_reforged"), 344, CATEGORY);
    public static final class_304 SHOW_NBT_SPAWN_EGG = new class_304("keybinding.%s.show_nbt_spawn_egg".formatted("tooltips_reforged"), 346, CATEGORY);
    public static final class_304 SHOW_ITEM_TAG = new class_304("keybinding.%s.show_item_tag".formatted("tooltips_reforged"), 345, CATEGORY);
    private boolean pressing;
    private Pressed pressed;

    private static class_3675.class_306 getBoundKey(class_304 binding) {
        return ((KeyBindingAccessor)binding).getBoundKey();
    }

    private static boolean pressed(class_304 binding) {
        return !TooltipKeyManager.isUnknownKey(binding) && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)TooltipKeyManager.getBoundKey(binding).method_1444());
    }

    private static boolean isUnknownKey(class_304 binding) {
        return TooltipKeyManager.getBoundKey(binding) == class_3675.field_16237;
    }

    public void renderTick() {
        if (TooltipKeyManager.pressed(SHOW_ITEM_TAG)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.ITEM_TAG ? Pressed.NONE : Pressed.ITEM_TAG;
                this.pressing = true;
            }
        } else if (TooltipKeyManager.pressed(SHOW_SPECIFIC_INFO)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.SPECIFIC ? Pressed.NONE : Pressed.SPECIFIC;
                this.pressing = true;
            }
        } else if (TooltipKeyManager.pressed(SHOW_NBT_SPAWN_EGG)) {
            if (!this.pressing) {
                this.pressed = this.pressed == Pressed.NBT ? Pressed.NONE : Pressed.NBT;
                this.pressing = true;
            }
        } else {
            this.pressing = false;
        }
    }

    public PressState itemTag() {
        return TooltipKeyManager.isUnknownKey(SHOW_ITEM_TAG) ? PressState.HIDE : (this.pressed == Pressed.ITEM_TAG ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public PressState specific() {
        return TooltipKeyManager.isUnknownKey(SHOW_SPECIFIC_INFO) ? PressState.HIDE : (this.pressed == Pressed.SPECIFIC ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public PressState nbt() {
        return TooltipKeyManager.isUnknownKey(SHOW_NBT_SPAWN_EGG) ? PressState.HIDE : (this.pressed == Pressed.NBT ? PressState.PRESSED : PressState.UNPRESSED);
    }

    public static String itemTagKeyTranslation() {
        return class_1074.method_4662((String)SHOW_ITEM_TAG.method_1428(), (Object[])new Object[0]);
    }

    public static String specificKeyTranslation() {
        return class_1074.method_4662((String)SHOW_SPECIFIC_INFO.method_1428(), (Object[])new Object[0]);
    }

    public static String nbtKeyTranslation() {
        return class_1074.method_4662((String)SHOW_NBT_SPAWN_EGG.method_1428(), (Object[])new Object[0]);
    }

    private static enum Pressed {
        NONE,
        ITEM_TAG,
        SPECIFIC,
        NBT;

    }

    public static enum PressState {
        HIDE(false, false),
        UNPRESSED(true, false),
        PRESSED(true, true);

        private final boolean show;
        private final boolean showDetail;

        private PressState(boolean show, boolean showDetail) {
            this.show = show;
            this.showDetail = showDetail;
        }

        public boolean show() {
            return this.show;
        }

        public boolean showDetail() {
            return this.showDetail;
        }
    }
}

