/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.vaultleaderboards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.godlycow.org.vaultleaderboards.VaultLeaderboards;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LeaderboardManager {
    private final VaultLeaderboards plugin;
    private final Economy economy;
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final Map<UUID, Double> balances = new HashMap<UUID, Double>();

    public LeaderboardManager(VaultLeaderboards plugin, Economy economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public void updateLeaderboard() {
        this.balances.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                double balance = this.economy.getBalance(player);
                this.balances.put(player.getUniqueId(), balance);
                if (!this.plugin.getConfig().getBoolean("settings.debug", false)) continue;
                this.plugin.getLogger().info("Loaded " + player.getName() + " \u2192 " + balance);
            }
        });
    }

    public Component getTopPlayerComponent(int rank) {
        List sorted = this.balances.entrySet().stream().sorted((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue())).limit(this.plugin.getConfig().getInt("settings.top-limit", 10)).collect(Collectors.toList());
        if (rank <= 0 || rank > sorted.size()) {
            return this.mini.deserialize((Object)"<red>N/A</red>");
        }
        Map.Entry entry = (Map.Entry)sorted.get(rank - 1);
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
        String name = player.getName() != null ? player.getName() : "Unknown";
        String template = this.plugin.getConfig().getString("placeholders.top", "<yellow><rank>. <green><player></green> - <aqua>$<balance>");
        String result = template.replace("<rank>", String.valueOf(rank)).replace("<player>", name).replace("<balance>", this.formatBalance((Double)entry.getValue()));
        return this.mini.deserialize((Object)result);
    }

    public Component getPlayerRankComponent(String name) {
        Map.Entry entry;
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
        if (!this.balances.containsKey(player.getUniqueId())) {
            return this.mini.deserialize((Object)"<red>N/A</red>");
        }
        List sorted = this.balances.entrySet().stream().sorted((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue())).collect(Collectors.toList());
        int rank = 1;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext() && !((UUID)(entry = (Map.Entry)iterator.next()).getKey()).equals(player.getUniqueId())) {
            ++rank;
        }
        String template = this.plugin.getConfig().getString("placeholders.player", "<yellow><player></yellow> is <green>#<rank></green> with <aqua>$<balance>");
        String result = template.replace("<player>", name).replace("<rank>", String.valueOf(rank)).replace("<balance>", this.formatBalance(this.balances.get(player.getUniqueId())));
        return this.mini.deserialize((Object)result);
    }

    public Component getServerAverageComponent() {
        if (this.balances.isEmpty()) {
            return this.mini.deserialize((Object)"<red>N/A</red>");
        }
        double average = this.balances.values().stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        String template = this.plugin.getConfig().getString("placeholders.server-average", "<yellow>Server Average: <aqua>$<balance>");
        String result = template.replace("<balance>", this.formatBalance(average));
        return this.mini.deserialize((Object)result);
    }

    private String formatBalance(double balance) {
        if (balance >= 1.0E9) {
            return String.format("%.2fB", balance / 1.0E9);
        }
        if (balance >= 1000000.0) {
            return String.format("%.2fM", balance / 1000000.0);
        }
        if (balance >= 1000.0) {
            return String.format("%.2fk", balance / 1000.0);
        }
        return String.format("%.2f", balance);
    }
}

