/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.vaultleaderboards;

import me.yourname.yourplugin.bstats.bukkit.Metrics;
import net.godlycow.io.vaultleaderboards.LeaderboardManager;
import net.godlycow.io.vaultleaderboards.LeaderboardPlaceholder;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class VaultLeaderboards
extends JavaPlugin {
    private static VaultLeaderboards instance;
    private Economy economy;
    private LeaderboardManager leaderboardManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault or an economy plugin not found! Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.leaderboardManager = new LeaderboardManager(this, this.economy);
        this.leaderboardManager.updateLeaderboard();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new LeaderboardPlaceholder(this, this.leaderboardManager).register();
            this.getLogger().info("Registered PlaceholderAPI placeholders.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found \u2014 placeholders won't work.");
        }
        long refreshSeconds = this.getConfig().getLong("settings.refresh-interval", 60L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this.leaderboardManager::updateLeaderboard, 20L, refreshSeconds * 20L);
        this.getCommand("vaultleaderboards").setExecutor((sender, command, label, args) -> {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("vaultleaderboards.reload")) {
                    sender.sendMessage("\u00a7cYou lack permission to reload VaultLeaderboards.");
                    return true;
                }
                this.reloadConfig();
                this.leaderboardManager.updateLeaderboard();
                sender.sendMessage("\u00a7aVaultLeaderboards config reloaded!");
                return true;
            }
            sender.sendMessage("\u00a7eVaultLeaderboards by _GodlyCow");
            sender.sendMessage("\u00a7eUse /vaultleaderboards reload");
            return true;
        });
        int pluginId = 27346;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("VaultLeaderboards enabled successfully!");
    }

    public void onDisable() {
        this.getLogger().info("VaultLeaderboards disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public static VaultLeaderboards getInstance() {
        return instance;
    }
}

