package dev.mattidragon.jsonpatcher.metapatch;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;
import dev.mattidragon.jsonpatcher.trust.TrustProvider;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.resource.*;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.*;
import java.util.function.Predicate;

public class MetapatchResourcePack implements class_3262, TrustProvider {
    public static final Gson GSON = new Gson();

    public final class_3264 type;
    private final Map<class_2960, JsonObject> files = new HashMap<>();
    private final List<FileFilter> filters = new ArrayList<>();
    private final Set<String> namespaces = new HashSet<>();

    public MetapatchResourcePack(class_3264 type) {
        this.type = type;
    }

    public void clear() {
        files.clear();
        filters.clear();
        namespaces.clear();
    }

    public void set(Map<class_2960, JsonObject> files, List<FileFilter> deletedFiles) {
        this.files.clear();
        this.files.putAll(files);
        this.filters.clear();
        this.filters.addAll(deletedFiles);
        namespaces.clear();
        files.keySet().forEach(id -> namespaces.add(id.method_12836()));
    }

    public boolean isDeleted(class_2960 id) {
        // The last filter added will get priority
        for (var filter : filters.reversed()) {
            if (filter.target().test(id)) {
                return !filter.allow();
            }
        }
        return false;
    }

    public Map<class_2960, class_3298> findResources(String startingPath, Predicate<class_2960> allowedPathPredicate) {
        var map = new HashMap<class_2960, class_3298>();
        files.forEach((id, file) -> {
            if (id.method_12832().startsWith(startingPath) && allowedPathPredicate.test(id)) {
                map.put(id, makeResource(id));
            }
        });
        return map;
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14410(String... segments) {
        return null;
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        if (type != this.type) return null;
        var file = files.get(id);
        if (file == null) return null;

        return () -> {
            var out = new ByteArrayOutputStream();
            var writer = new OutputStreamWriter(out);
            GSON.toJson(file, writer);
            writer.close();
            return new ByteArrayInputStream(out.toByteArray());
        };
    }

    @Override
    public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
        if (type != this.type) return;

        files.forEach((id, file) -> {
            if (id.method_12836().equals(namespace) && id.method_12832().startsWith(prefix)) {
                consumer.accept(id, method_14405(type, id));
            }
        });
    }

    @Override
    public Set<String> method_14406(class_3264 type) {
        return namespaces;
    }

    @Nullable
    @Override
    public <T> T method_14407(class_3270<T> metaReader) {
        var metadata = getMetadata(type);
        var stream = new ByteArrayInputStream(metadata.getBytes());

        return class_3255.method_14392(metaReader, stream);
    }

    @Override
    public class_9224 method_56926() {
        return new class_9224("jsonpatcher:meta_patch", 
                class_2561.method_43470("JsonPatcher MetaPatch Resource Pack"), 
                class_5352.field_25348, 
                Optional.empty());
    }

    @Override
    public void close() {

    }

    private static String getMetadata(class_3264 type) {
        return """
            {
              "pack": {
                "pack_format": %s,
                "description": "JsonPatcher MetaPatch Resource Pack"
              }
            }
            """.formatted(class_155.method_16673().method_48017(type));
    }

    @Nullable
    public class_3298 makeResource(class_2960 id) {
        var supplier = method_14405(type, id);
        if (supplier != null) {
            return new class_3298(this, supplier);
        }
        return null;
    }

    @Override
    public TrustLevel jsonpatcher$trustLevel() {
        // Metapatching can be done by untrusted code
        // Patches should never load from this pack, but just to be safe:
        return TrustLevel.UNTRUSTED;
    }
}
