package dev.mattidragon.jsonpatcher.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchResourcePack;
import dev.mattidragon.jsonpatcher.misc.MetaPatchPackAccess;
import dev.mattidragon.jsonpatcher.patch.PatchingContext;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6861;
import net.minecraft.resource.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;
import java.util.function.Predicate;

@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
@Mixin(class_6861.class)
public class LifecycledResourceManagerImplMixin implements MetaPatchPackAccess {
    @Unique
    private MetapatchResourcePack jsonpatcher$metaPatchPack;
    @Unique
    private PatchingContext jsonpatcher$context;

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Ljava/lang/Object;<init>()V", shift = At.Shift.AFTER, remap = false))
    private void init(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
        jsonpatcher$metaPatchPack = new MetapatchResourcePack(type);
        jsonpatcher$context = new PatchingContext(type);
    }
    
    @Inject(method = "<init>", at = @At("RETURN"))
    private void initPatches(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
        jsonpatcher$context.load((class_3300) this);
    }

    @ModifyReturnValue(method = "getAllNamespaces", at = @At("RETURN"))
    private Set<String> patchNamespaceSet(Set<String> value) {
        var set = new HashSet<>(value);
        set.addAll(jsonpatcher$metaPatchPack.method_14406(jsonpatcher$metaPatchPack.type));
        return set;
    }
    
    @ModifyReturnValue(method = "getAllResources", at = @At("RETURN"))
    private List<class_3298> injectResourcesIntoGetAll(List<class_3298> original, class_2960 id) {
        if (jsonpatcher$metaPatchPack.isDeleted(id)) {
            return new ArrayList<>();
        }
        var list = new ArrayList<>(original);
        var metaResource = jsonpatcher$metaPatchPack.makeResource(id);
        if (metaResource != null) list.add(metaResource);
        list.forEach(resource -> jsonpatcher$context.patchResource(id, resource));
        return list;
    }
    
    @ModifyReturnValue(method = "getResource", at = @At("RETURN"))
    private Optional<class_3298> injectResourcesIntoGet(Optional<class_3298> original, class_2960 id) {
        if (jsonpatcher$metaPatchPack.isDeleted(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(jsonpatcher$metaPatchPack.makeResource(id))
                .or(() -> original)
                .map(resource -> {
                    jsonpatcher$context.patchResource(id, resource);
                    return resource;
                });
    }

    @ModifyReturnValue(method = "findResources", at = @At("RETURN"))
    private Map<class_2960, class_3298> injectResourcesIntoFind(Map<class_2960, class_3298> map, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        map.putAll(jsonpatcher$metaPatchPack.findResources(startingPath, allowedPathPredicate));
        map.keySet().removeIf(jsonpatcher$metaPatchPack::isDeleted);
        map.forEach(jsonpatcher$context::patchResource);
        return map;
    }

    @ModifyReturnValue(method = "findAllResources", at = @At("RETURN"))
    private Map<class_2960, List<class_3298>> injectResourcesIntoFindAll(Map<class_2960, List<class_3298>> map, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        jsonpatcher$metaPatchPack.findResources(startingPath, allowedPathPredicate)
                .forEach((id, resource) -> map.computeIfAbsent(id, i -> new ArrayList<>()).add(resource));
        map.keySet().removeIf(jsonpatcher$metaPatchPack::isDeleted);
        map.forEach((id, resources) -> resources.forEach(resource -> jsonpatcher$context.patchResource(id, resource)));
        return map;
    }

    @Override
    public MetapatchResourcePack jsonpatcher$getMetaPatchPack() {
        return jsonpatcher$metaPatchPack;
    }
}
