package dev.mattidragon.jsonpatcher.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mattidragon.jsonpatcher.patch.PatchingContext;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5912;
import net.minecraft.class_7655;
import net.minecraft.class_7782;
import net.minecraft.registry.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;

import java.util.List;
import java.util.Map;

@Mixin(class_7655.class)
public abstract class RegistryLoaderMixin {
    @WrapOperation(method = "loadFromNetwork(Ljava/util/Map;Lnet/minecraft/resource/ResourceFactory;Lnet/minecraft/registry/DynamicRegistryManager;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;", 
            at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/RegistryLoader;load(Lnet/minecraft/registry/RegistryLoader$RegistryLoadable;Lnet/minecraft/registry/DynamicRegistryManager;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;"))
    private static class_5455.class_6890 disablePatchingForNetworkRegistries(@Coerce Object loadable,
                                                                                        class_5455 baseRegistryManager,
                                                                                        List<class_7655.class_7657<?>> entries,
                                                                                        Operation<class_5455.class_6890> original,
                                                                                        Map<class_5321<? extends class_2378<?>>, List<class_7782.class_9176>> data,
                                                                                        class_5912 factory,
                                                                                        class_5455 registryManager,
                                                                                        List<class_7655.class_7657<?>> entries2) {
        try (var __ = PatchingContext.disablePatching()) {
            return original.call(loadable, baseRegistryManager, entries);
        }
    }
}
