package dev.mattidragon.jsonpatcher.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.mattidragon.jsonpatcher.misc.ResourceAccess;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;

import java.io.InputStream;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_3298;
import net.minecraft.class_7367;
import net.minecraft.class_9226;

@Mixin(class_3298.class)
public class ResourceMixin implements ResourceAccess {
    @Unique
    private boolean disableKnowPack = false;
    
    @Final
    @Mutable
    @Shadow
    private class_7367<InputStream> inputSupplier;

    @Override
    public void jsonpatcher$disableKnowPack() {
        disableKnowPack = true;
    }

    @Override
    public void jsonpatcher$modifyInputStreamSupplier(UnaryOperator<class_7367<InputStream>> operator) {
        inputSupplier = operator.apply(inputSupplier);
    }

    @ModifyReturnValue(method = "getKnownPackInfo", at = @At("RETURN"))
    private Optional<class_9226> disableKnownPackInfoForPatchedResources(@SuppressWarnings("OptionalUsedAsFieldOrParameterType") Optional<class_9226> original) {
        if (disableKnowPack) {
            return Optional.empty();
        } else {
            return original;
        }
    }
}
