package dev.mattidragon.jsonpatcher.mixin.trust;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.mattidragon.jsonpatcher.trust.MutableTrustProvider;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;
import net.minecraft.class_3258;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_3258.class_8615.class)
public class ZipResourcePackFactoryMixin implements MutableTrustProvider {
    @Unique
    private TrustLevel jsonpatcher$trustLevel = TrustLevel.UNTRUSTED;

    @Override
    public TrustLevel jsonpatcher$trustLevel() {
        return jsonpatcher$trustLevel;
    }

    @Override
    public void jsonpatcher$setTrustLevel(TrustLevel trustLevel) {
        jsonpatcher$trustLevel = trustLevel;
    }

    @ModifyExpressionValue(
            method = {"open", "openWithOverlays"},
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/resource/ResourcePackInfo;Lnet/minecraft/resource/ZipResourcePack$ZipFileWrapper;Ljava/lang/String;)Lnet/minecraft/resource/ZipResourcePack;")
    )
    private class_3258 injectTrust(class_3258 original) {
        ((MutableTrustProvider)original).jsonpatcher$setTrustLevel(jsonpatcher$trustLevel);
        return original;
    }
}
