package dev.mattidragon.jsonpatcher.patch;

import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.misc.DumpManager;
import dev.mattidragon.jsonpatcher.misc.ResourceAccess;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3902;

public class PatchingContext {
    private static final ThreadLocal<class_3902> DISABLED = new ThreadLocal<>();

    private final class_3264 resourceType;
    private boolean loaded = false;
    private Patcher patcher = null;

    public PatchingContext(class_3264 resourceType) {
        this.resourceType = resourceType;
    }

    public static Enabler disablePatching() {
        return new Enabler();
    }

    public void load(class_3300 manager) {
        if (loaded) throw new IllegalStateException("Already loaded");

        var patches = PatchLoader.loadPatches(Patcher.PATCH_RUNNER, manager, resourceType);
        DumpManager.cleanDump(resourceType.method_14413());

        JsonPatcher.RELOAD_LOGGER.info("Loaded {} patches for reload {}", patches.size(), resourceType.name());

        patcher = new Patcher(resourceType, patches);
        patcher.runMetaPatches(manager, Patcher.PATCH_RUNNER);
        loaded = true;
    }

    public void patchResource(class_2960 id, class_3298 resource) {
        if (!id.method_12832().endsWith(".json")) return;
        if (DISABLED.get() != null) return;
        
        if (!loaded) throw new IllegalStateException("Context not loaded");
        if (patcher.hasPatches(id)) {
            ((ResourceAccess) resource).jsonpatcher$disableKnowPack();
            ((ResourceAccess) resource).jsonpatcher$modifyInputStreamSupplier(stream -> patcher.patchInputStream(id, stream));
        }
    }

    public static class Enabler implements AutoCloseable {
        private Enabler() {
            DISABLED.set(class_3902.field_17274);
        }

        @Override
        public void close() {
            DISABLED.remove();
        }
    }
}
