package dev.mattidragon.jsonpatcher.patch.global;

import dev.mattidragon.jsonpatcher.JsonPatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class GlobalPatchScanner {
    public static final Path BASE_DIR = JsonPatcher.DATA_DIR.resolve("global_patches");

    private GlobalPatchScanner() {
    }

    public static Map<class_2960, class_7367<InputStream>> scan(class_3264 type) {
        var path = BASE_DIR.resolve(type.method_14413());

        try (var stream = Files.walk(path)) {
            var out = new HashMap<class_2960, class_7367<InputStream>>();

            stream.filter(Files::isRegularFile)
                    .filter(patchPath -> patchPath.toString().endsWith(".jsonpatch"))
                    .forEach(patchPath -> {
                        var fileName = BASE_DIR.relativize(patchPath).toString();
                        var cleanedName = fileName.substring(0, fileName.length() - ".jsonpatch".length())
                                .replace(BASE_DIR.getFileSystem().getSeparator(), "/")
                                .replaceFirst("^\\./", "");
                        var id = class_2960.method_43902("global", "/" + cleanedName);
                        if (id == null) return;
                        out.put(id, class_7367.create(patchPath));
                    });

            return out;
        } catch (IOException e) {
            JsonPatcher.MAIN_LOGGER.error("Failed to scan global patches", e);
            return Map.of();
        }
    }
}
