/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher;

import dev.mattidragon.jsonpatcher.config.Config;
import dev.mattidragon.jsonpatcher.misc.DumpManager;
import dev.mattidragon.jsonpatcher.patch.ErrorLogger;
import dev.mattidragon.jsonpatcher.patch.global.GlobalDirSetup;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatch;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatchLoader;
import dev.mattidragon.jsonpatcher.remap.MappingsLoader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPatcher
implements ModInitializer {
    public static final Path DATA_DIR = FabricLoader.getInstance().getGameDir().resolve("jsonpatcher");
    private static final Set<String> SUPPORTED_VERSIONS = new HashSet<String>(Set.of("2"));
    public static final String MOD_ID = "jsonpatcher";
    public static final Logger MAIN_LOGGER = LoggerFactory.getLogger((String)"jsonpatcher");
    private static final String RELOAD_LOGGER_NAME = "JsonPatcher Reload";
    public static final Logger RELOAD_LOGGER = LoggerFactory.getLogger((String)"JsonPatcher Reload");

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        MappingsLoader.init();
        Config.MANAGER.get();
        DumpManager.cleanDump("");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ErrorLogger.CURRENT.set(error -> {
            class_3324 manager = server.method_3760();
            for (class_3222 player : manager.method_14571()) {
                if (!manager.method_14569(player.method_7334())) continue;
                player.method_43496(error);
            }
        }));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ErrorLogger.CURRENT.remove());
        GlobalDirSetup.setupDirs();
        GlobalPatchLoader.loadGlobalPatches();
        GlobalPatchLoader.runEntrypoint(GlobalPatch.Entrypoint.MAIN);
    }

    private static void hackLog4j() {
        MAIN_LOGGER.debug("About to hack log4j config");
        try {
            org.apache.logging.log4j.core.Logger log4jLogger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)RELOAD_LOGGER_NAME);
            Configuration configuration = log4jLogger.getContext().getConfiguration();
            RandomAccessFileAppender appender = ((RandomAccessFileAppender.Builder)((RandomAccessFileAppender.Builder)RandomAccessFileAppender.newBuilder().setName("JsonPatcherFile")).setFileName("jsonpatcher/jsonpatcher.log").setLayout((Layout)PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss}] [%t/%level] (%logger) %msg{nolookups}%n").build())).setAppend(false).build();
            appender.start();
            configuration.addAppender((Appender)appender);
            configuration.addLoggerAppender(log4jLogger, (Appender)appender);
            configuration.setLoggerAdditive(log4jLogger, false);
            log4jLogger.setLevel(Level.toLevel((String)System.getProperty("jsonpatcher.log.level"), (Level)Level.INFO));
            MAIN_LOGGER.debug("Successfully hacked log4j config. Now we have our own file!");
        }
        catch (IncompatibleClassChangeError | NoClassDefFoundError | RuntimeException e) {
            MAIN_LOGGER.error("Failed to hack log4j. All output will be logged to main log.", e);
        }
    }

    public static boolean isSupportedVersion(String version) {
        return SUPPORTED_VERSIONS.contains(version);
    }

    static {
        JsonPatcher.hackLog4j();
    }
}

