/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.config;

import dev.mattidragon.jsonpatcher.config.Config;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;

public final class MutableConfig {
    private int patchTimeoutMillis;
    private boolean throwOnFailure;
    private boolean dumpPatchedFiles;
    private boolean dumpCompiledPatches;
    private TrustLevel reflectionMinTrustLevel;

    private MutableConfig(Source immutable) {
        this.patchTimeoutMillis = immutable.patchTimeoutMillis();
        this.throwOnFailure = immutable.throwOnFailure();
        this.dumpPatchedFiles = immutable.dumpPatchedFiles();
        this.dumpCompiledPatches = immutable.dumpCompiledPatches();
        this.reflectionMinTrustLevel = immutable.reflectionMinTrustLevel();
    }

    public Config toImmutable() {
        return new Config(this.patchTimeoutMillis, this.throwOnFailure, this.dumpPatchedFiles, this.dumpCompiledPatches, this.reflectionMinTrustLevel);
    }

    public int patchTimeoutMillis() {
        return this.patchTimeoutMillis;
    }

    public boolean throwOnFailure() {
        return this.throwOnFailure;
    }

    public boolean dumpPatchedFiles() {
        return this.dumpPatchedFiles;
    }

    public boolean dumpCompiledPatches() {
        return this.dumpCompiledPatches;
    }

    public TrustLevel reflectionMinTrustLevel() {
        return this.reflectionMinTrustLevel;
    }

    public void patchTimeoutMillis(int patchTimeoutMillis) {
        this.patchTimeoutMillis = patchTimeoutMillis;
    }

    public void throwOnFailure(boolean throwOnFailure) {
        this.throwOnFailure = throwOnFailure;
    }

    public void dumpPatchedFiles(boolean dumpPatchedFiles) {
        this.dumpPatchedFiles = dumpPatchedFiles;
    }

    public void dumpCompiledPatches(boolean dumpCompiledPatches) {
        this.dumpCompiledPatches = dumpCompiledPatches;
    }

    public void reflectionMinTrustLevel(TrustLevel reflectionMinTrustLevel) {
        this.reflectionMinTrustLevel = reflectionMinTrustLevel;
    }

    public static sealed interface Source
    permits Config {
        public int patchTimeoutMillis();

        public boolean throwOnFailure();

        public boolean dumpPatchedFiles();

        public boolean dumpCompiledPatches();

        public TrustLevel reflectionMinTrustLevel();

        default public MutableConfig toMutable() {
            return new MutableConfig(this);
        }
    }
}

