/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.metapatch;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.mattidragon.jsonpatcher.lang.runtime.EvaluationContext;
import dev.mattidragon.jsonpatcher.lang.runtime.lib.builder.DontBind;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import dev.mattidragon.jsonpatcher.metapatch.FileFilter;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchResourcePack;
import dev.mattidragon.jsonpatcher.misc.GsonConverter;
import dev.mattidragon.jsonpatcher.misc.ValueOps;
import dev.mattidragon.jsonpatcher.patch.PatchTarget;
import dev.mattidragon.jsonpatcher.patch.PatchingContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class MetapatchLibrary {
    @DontBind
    private final Map<class_2960, JsonObject> addedFiles = new HashMap<class_2960, JsonObject>();
    @DontBind
    private final List<FileFilter> filters = new ArrayList<FileFilter>();
    @DontBind
    private final class_3300 resourceManager;

    public MetapatchLibrary(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    @DontBind
    public void apply(MetapatchResourcePack metaPack) {
        metaPack.set(this.addedFiles, this.filters);
    }

    @DontBind
    public void clear() {
        this.addedFiles.clear();
        this.filters.clear();
    }

    @DontBind
    private boolean isDeleted(class_2960 id) {
        for (FileFilter filter : this.filters.reversed()) {
            if (!filter.target().test(id)) continue;
            return !filter.allow();
        }
        return false;
    }

    @DontBind
    private static Value.ObjectValue valueFromResource(class_3298 resource) throws IOException {
        return GsonConverter.fromGson((JsonObject)MetapatchResourcePack.GSON.fromJson((Reader)new InputStreamReader(resource.method_14482()), JsonObject.class));
    }

    public void addFile(EvaluationContext context, Value.StringValue idString, Value.ObjectValue file) {
        class_2960 id = class_2960.method_60654((String)idString.value());
        if (this.isDeleted(id)) {
            this.filters.add(new FileFilter(new PatchTarget(Optional.of(id.method_12836()), Optional.of(new PatchTarget.Path((Either<String, Pair<String, String>>)Either.left((Object)id.method_12832()))), Optional.empty()), true));
        }
        this.addedFiles.put(id, GsonConverter.toGson(file));
    }

    public void deleteFile(EvaluationContext context, Value.StringValue idString) {
        class_2960 id = class_2960.method_60654((String)idString.value());
        this.filters.add(new FileFilter(new PatchTarget(Optional.of(id.method_12836()), Optional.of(new PatchTarget.Path((Either<String, Pair<String, String>>)Either.left((Object)id.method_12832()))), Optional.empty()), false));
    }

    public void deleteFiles(EvaluationContext context, Value targetValue) {
        PatchTarget target = (PatchTarget)((Pair)PatchTarget.CODEC.decode((DynamicOps)ValueOps.INSTANCE, (Object)targetValue).getOrThrow(error -> new IllegalStateException("Failed to parse target: " + error))).getFirst();
        this.filters.add(new FileFilter(target, false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value getFile(EvaluationContext context, Value.StringValue idString) {
        class_2960 id = class_2960.method_60654((String)idString.value());
        try (PatchingContext.Enabler __ = PatchingContext.disablePatching();){
            Optional resource = this.resourceManager.method_14486(id);
            if (!resource.isPresent()) return Value.NullValue.NULL;
            Value.ObjectValue objectValue = MetapatchLibrary.valueFromResource((class_3298)resource.get());
            return objectValue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Value getFiles(EvaluationContext context, Value.StringValue idString) {
        class_2960 id = class_2960.method_60654((String)idString.value());
        Value.ArrayValue array = new Value.ArrayValue();
        try (PatchingContext.Enabler __ = PatchingContext.disablePatching();){
            List resources = this.resourceManager.method_14489(id);
            for (class_3298 resource : resources) {
                array.value().add(MetapatchLibrary.valueFromResource(resource));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return array;
    }

    public Value searchFiles(EvaluationContext context, Value targetValue) {
        int slashIndex;
        PatchTarget target = (PatchTarget)((Pair)PatchTarget.CODEC.decode((DynamicOps)ValueOps.INSTANCE, (Object)targetValue).getOrThrow(error -> new IllegalStateException("Failed to parse target: " + error))).getFirst();
        String startingPath = "";
        if (target.path().isPresent()) {
            startingPath = (String)target.path().get().path().map(p -> p, Pair::getFirst);
        }
        if ((slashIndex = startingPath.lastIndexOf(47)) != -1) {
            startingPath = startingPath.substring(0, slashIndex);
        }
        Value.ObjectValue out = new Value.ObjectValue();
        try (PatchingContext.Enabler __ = PatchingContext.disablePatching();){
            Map found = this.resourceManager.method_14488(startingPath, (Predicate)target);
            for (Map.Entry entry : found.entrySet()) {
                class_2960 id = (class_2960)entry.getKey();
                class_3298 resource = (class_3298)entry.getValue();
                out.value().put(id.toString(), MetapatchLibrary.valueFromResource(resource));
            }
        }
        catch (Exception e) {
            throw new UncheckedIOException(new IOException("Failed to search files", e));
        }
        return out;
    }
}

