/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.metapatch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.mattidragon.jsonpatcher.metapatch.FileFilter;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;
import dev.mattidragon.jsonpatcher.trust.TrustProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class MetapatchResourcePack
implements class_3262,
TrustProvider {
    public static final Gson GSON = new Gson();
    public final class_3264 type;
    private final Map<class_2960, JsonObject> files = new HashMap<class_2960, JsonObject>();
    private final List<FileFilter> filters = new ArrayList<FileFilter>();
    private final Set<String> namespaces = new HashSet<String>();

    public MetapatchResourcePack(class_3264 type) {
        this.type = type;
    }

    public void clear() {
        this.files.clear();
        this.filters.clear();
        this.namespaces.clear();
    }

    public void set(Map<class_2960, JsonObject> files, List<FileFilter> deletedFiles) {
        this.files.clear();
        this.files.putAll(files);
        this.filters.clear();
        this.filters.addAll(deletedFiles);
        this.namespaces.clear();
        files.keySet().forEach(id -> this.namespaces.add(id.method_12836()));
    }

    public boolean isDeleted(class_2960 id) {
        for (FileFilter filter : this.filters.reversed()) {
            if (!filter.target().test(id)) continue;
            return !filter.allow();
        }
        return false;
    }

    public Map<class_2960, class_3298> findResources(String startingPath, Predicate<class_2960> allowedPathPredicate) {
        HashMap<class_2960, class_3298> map = new HashMap<class_2960, class_3298>();
        this.files.forEach((id, file) -> {
            if (id.method_12832().startsWith(startingPath) && allowedPathPredicate.test((class_2960)id)) {
                map.put((class_2960)id, this.makeResource((class_2960)id));
            }
        });
        return map;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... segments) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        if (type != this.type) {
            return null;
        }
        JsonObject file = this.files.get(id);
        if (file == null) {
            return null;
        }
        return () -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            GSON.toJson((JsonElement)file, (Appendable)writer);
            writer.close();
            return new ByteArrayInputStream(out.toByteArray());
        };
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        if (type != this.type) {
            return;
        }
        this.files.forEach((id, file) -> {
            if (id.method_12836().equals(namespace) && id.method_12832().startsWith(prefix)) {
                consumer.accept(id, this.method_14405(type, (class_2960)id));
            }
        });
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) {
        String metadata = MetapatchResourcePack.getMetadata(this.type);
        ByteArrayInputStream stream = new ByteArrayInputStream(metadata.getBytes());
        return (T)class_3255.method_14392(metaReader, (InputStream)stream);
    }

    public class_9224 method_56926() {
        return new class_9224("jsonpatcher:meta_patch", (class_2561)class_2561.method_43470((String)"JsonPatcher MetaPatch Resource Pack"), class_5352.field_25348, Optional.empty());
    }

    public void close() {
    }

    private static String getMetadata(class_3264 type) {
        return "{\n  \"pack\": {\n    \"pack_format\": %s,\n    \"description\": \"JsonPatcher MetaPatch Resource Pack\"\n  }\n}\n".formatted(class_155.method_16673().method_48017(type));
    }

    @Nullable
    public class_3298 makeResource(class_2960 id) {
        class_7367<InputStream> supplier = this.method_14405(this.type, id);
        if (supplier != null) {
            return new class_3298((class_3262)this, supplier);
        }
        return null;
    }

    @Override
    public TrustLevel jsonpatcher$trustLevel() {
        return TrustLevel.UNTRUSTED;
    }
}

