/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.config.Config;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class DumpManager {
    private static final Gson DUMP_GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void dumpIfEnabled(class_2960 id, class_3264 resourceType, JsonElement patchedData) {
        if (((Config)Config.MANAGER.get()).dumpPatchedFiles()) {
            try {
                Path file = DumpManager.getDumpPath(resourceType.method_14413()).resolve(Path.of(id.method_12836(), id.method_12832().split("/")));
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]));){
                    DUMP_GSON.toJson(patchedData, (Appendable)writer);
                }
            }
            catch (IOException e) {
                JsonPatcher.RELOAD_LOGGER.error("Failed to dump patched file {}", (Object)id, (Object)e);
            }
        }
    }

    public static void cleanDump(@Nullable String dumpLocation) {
        if (dumpLocation == null) {
            return;
        }
        Path file = DumpManager.getDumpPath(dumpLocation);
        if (Files.exists(file, new LinkOption[0])) {
            ArrayList<IOException> errors = new ArrayList<IOException>();
            try (Stream<Path> stream = Files.walk(file, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                });
                if (!errors.isEmpty()) {
                    IOException error = new IOException("Errors while deleting dumped files");
                    errors.forEach(error::addSuppressed);
                    throw error;
                }
            }
            catch (IOException e) {
                JsonPatcher.RELOAD_LOGGER.error("Failed to clean dump directory", (Throwable)e);
            }
        }
    }

    public static Path getDumpPath(String dumpLocation) {
        return FabricLoader.getInstance().getGameDir().resolve("jsonpatcher/dump").resolve(dumpLocation);
    }
}

