/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.misc;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Set;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class GsonConverter {
    private static final ThreadLocal<Set<Value>> TO_GSON_RECURSION_TRACKER = ThreadLocal.withInitial(Sets::newIdentityHashSet);
    private static final ThreadLocal<Set<JsonElement>> FROM_GSON_RECURSION_TRACKER = ThreadLocal.withInitial(Sets::newIdentityHashSet);

    private GsonConverter() {
    }

    /*
     * Exception decompiling
     */
    public static JsonElement toGson(Value value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,104
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JsonObject toGson(Value.ObjectValue value) {
        JsonObject object = new JsonObject();
        for (Map.Entry entry : value.value().entrySet()) {
            object.add((String)entry.getKey(), GsonConverter.toGson((Value)entry.getValue()));
        }
        return object;
    }

    public static JsonArray toGson(Value.ArrayValue value) {
        JsonArray array = new JsonArray();
        for (Value entry : value.value()) {
            array.add(GsonConverter.toGson(entry));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value fromGson(JsonElement json) {
        try {
            Value.NullValue nullValue;
            if (!FROM_GSON_RECURSION_TRACKER.get().add(json)) {
                throw new IllegalStateException("recursive gson json tree");
            }
            JsonElement jsonElement = json;
            int n = 0;
            block11: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonObject.class, JsonArray.class, JsonPrimitive.class, JsonPrimitive.class, JsonPrimitive.class, JsonNull.class}, (Object)jsonElement, n)) {
                    case 0: {
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        nullValue = GsonConverter.fromGson(jsonObject);
                        break block11;
                    }
                    case 1: {
                        JsonArray jsonArray = (JsonArray)jsonElement;
                        nullValue = GsonConverter.fromGson(jsonArray);
                        break block11;
                    }
                    case 2: {
                        JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                        if (!primitive.isBoolean()) {
                            n = 3;
                            continue block11;
                        }
                        nullValue = Value.BooleanValue.of((boolean)primitive.getAsBoolean());
                        break block11;
                    }
                    case 3: {
                        JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                        if (!primitive.isNumber()) {
                            n = 4;
                            continue block11;
                        }
                        nullValue = new Value.NumberValue(primitive.getAsNumber().doubleValue());
                        break block11;
                    }
                    case 4: {
                        JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                        if (!primitive.isString()) {
                            n = 5;
                            continue block11;
                        }
                        nullValue = new Value.StringValue(primitive.getAsString());
                        break block11;
                    }
                    case 5: {
                        JsonNull jsonNull = (JsonNull)jsonElement;
                        nullValue = Value.NullValue.NULL;
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Can't convert %s to value".formatted(json));
                    }
                }
                break;
            }
            jsonElement = nullValue;
            return jsonElement;
        }
        finally {
            FROM_GSON_RECURSION_TRACKER.get().remove(json);
        }
    }

    public static Value.ObjectValue fromGson(JsonObject object) {
        Value.ObjectValue value = new Value.ObjectValue();
        for (Map.Entry entry : object.entrySet()) {
            value.value().put((String)entry.getKey(), GsonConverter.fromGson((JsonElement)entry.getValue()));
        }
        return value;
    }

    public static Value.ArrayValue fromGson(JsonArray array) {
        Value.ArrayValue value = new Value.ArrayValue();
        for (JsonElement entry : array) {
            value.value().add(GsonConverter.fromGson(entry));
        }
        return value;
    }
}

