/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataArray;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataBoolean;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataElement;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataNull;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataNumber;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataObject;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataString;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class MetadataOps
implements DynamicOps<MetadataElement> {
    public static final MetadataOps INSTANCE = new MetadataOps();

    private MetadataOps() {
    }

    public MetadataElement empty() {
        return new MetadataNull();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> outOps, MetadataElement input) {
        Map values;
        Object object;
        MetadataElement metadataElement = input;
        Objects.requireNonNull(metadataElement);
        MetadataElement metadataElement2 = metadataElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetadataNull.class, MetadataBoolean.class, MetadataNumber.class, MetadataString.class, MetadataArray.class, MetadataObject.class}, (Object)metadataElement2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                MetadataNull metadataNull = (MetadataNull)metadataElement2;
                object = outOps.empty();
                return (U)object;
            }
            case 1: {
                boolean value2;
                MetadataBoolean metadataBoolean = (MetadataBoolean)metadataElement2;
                try {
                    boolean bl;
                    value2 = bl = metadataBoolean.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = outOps.createBoolean(value2);
                return (U)object;
            }
            case 2: {
                double value3;
                MetadataNumber metadataNumber = (MetadataNumber)metadataElement2;
                {
                    double d;
                    value3 = d = metadataNumber.value();
                }
                object = outOps.createNumeric((Number)value3);
                return (U)object;
            }
            case 3: {
                String value4;
                MetadataString metadataString = (MetadataString)metadataElement2;
                {
                    String string;
                    value4 = string = metadataString.value();
                }
                object = outOps.createString(value4);
                return (U)object;
            }
            case 4: {
                List values2;
                MetadataArray metadataArray = (MetadataArray)metadataElement2;
                {
                    List list;
                    values2 = list = metadataArray.values();
                }
                object = outOps.createList(values2.stream().map(value -> this.convertTo(outOps, (MetadataElement)value)));
                return (U)object;
            }
            case 5: 
        }
        MetadataObject metadataObject = (MetadataObject)metadataElement2;
        {
            Map map;
            values = map = metadataObject.values();
        }
        object = outOps.createMap(values.entrySet().stream().map(entry -> Pair.of((Object)outOps.createString((String)entry.getKey()), this.convertTo(outOps, (MetadataElement)entry.getValue()))));
        return (U)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Number> getNumberValue(MetadataElement input) {
        double value;
        if (!(input instanceof MetadataNumber)) return DataResult.error(() -> "Not a number: " + String.valueOf(input));
        MetadataNumber metadataNumber = (MetadataNumber)input;
        try {
            double d;
            value = d = metadataNumber.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)value);
    }

    public MetadataElement createNumeric(Number i) {
        return new MetadataNumber(i.doubleValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<String> getStringValue(MetadataElement input) {
        String value;
        if (!(input instanceof MetadataString)) return DataResult.error(() -> "Not a string: " + String.valueOf(input));
        MetadataString metadataString = (MetadataString)input;
        try {
            String string;
            value = string = metadataString.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)value);
    }

    public MetadataElement createString(String value) {
        return new MetadataString(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Boolean> getBooleanValue(MetadataElement input) {
        boolean value;
        if (!(input instanceof MetadataBoolean)) return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
        MetadataBoolean metadataBoolean = (MetadataBoolean)input;
        try {
            boolean bl;
            value = bl = metadataBoolean.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)value);
    }

    public MetadataElement createBoolean(boolean value) {
        return new MetadataBoolean(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<MetadataElement> mergeToList(MetadataElement list, MetadataElement value) {
        List values;
        if (!(list instanceof MetadataArray)) return DataResult.error(() -> "Not a list: " + String.valueOf(list));
        MetadataArray metadataArray = (MetadataArray)list;
        try {
            List list2;
            values = list2 = metadataArray.values();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ArrayList<MetadataElement> newValues = new ArrayList<MetadataElement>(values);
        newValues.add(value);
        return DataResult.success((Object)new MetadataArray(newValues));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<MetadataElement> mergeToMap(MetadataElement map, MetadataElement key, MetadataElement value) {
        String string;
        Map values;
        Map map2;
        if (!(map instanceof MetadataObject)) return DataResult.error(() -> "Not a map: " + String.valueOf(map));
        MetadataObject metadataObject = (MetadataObject)map;
        try {
            values = map2 = metadataObject.values();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(key instanceof MetadataString)) return DataResult.error(() -> "Not a string: " + String.valueOf(key));
        map2 = (MetadataString)key;
        String keyString = string = map2.value();
        HashMap<String, MetadataElement> newValues = new HashMap<String, MetadataElement>(values);
        newValues.put(keyString, value);
        return DataResult.success((Object)new MetadataObject(newValues));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Stream<Pair<MetadataElement, MetadataElement>>> getMapValues(MetadataElement input) {
        Map values;
        if (!(input instanceof MetadataObject)) return DataResult.error(() -> "Not a map: " + String.valueOf(input));
        MetadataObject metadataObject = (MetadataObject)input;
        try {
            Map map;
            values = map = metadataObject.values();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success(values.entrySet().stream().map(entry -> Pair.of((Object)new MetadataString((String)entry.getKey()), (Object)((MetadataElement)entry.getValue()))));
    }

    public MetadataElement createMap(Stream<Pair<MetadataElement, MetadataElement>> map) {
        HashMap values = new HashMap();
        map.forEach(pair -> {
            String key;
            Object patt1$temp = pair.getFirst();
            if (!(patt1$temp instanceof MetadataString)) throw new IllegalArgumentException("Key is not a string: " + String.valueOf(pair.getFirst()));
            MetadataString $b$0 = (MetadataString)patt1$temp;
            try {
                String patt2$temp;
                key = patt2$temp = $b$0.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            values.put(key, (MetadataElement)pair.getSecond());
        });
        return new MetadataObject(values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Stream<MetadataElement>> getStream(MetadataElement input) {
        List values;
        if (!(input instanceof MetadataArray)) return DataResult.error(() -> "Not an array: " + String.valueOf(input));
        MetadataArray metadataArray = (MetadataArray)input;
        try {
            List list;
            values = list = metadataArray.values();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success(values.stream());
    }

    public MetadataElement createList(Stream<MetadataElement> input) {
        return new MetadataArray(input.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataElement remove(MetadataElement input, String key) {
        Map values;
        if (!(input instanceof MetadataObject)) return input;
        MetadataObject metadataObject = (MetadataObject)input;
        try {
            Map map;
            values = map = metadataObject.values();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        HashMap newValues = new HashMap(values);
        newValues.remove(key);
        return new MetadataObject(newValues);
    }
}

