/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import java.lang.runtime.SwitchBootstraps;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ValueOps
implements DynamicOps<Value> {
    public static final ValueOps INSTANCE = new ValueOps();

    private ValueOps() {
    }

    public Value empty() {
        return Value.NullValue.NULL;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> outOps, Value input) {
        Value value2 = input;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Value.NullValue.class, Value.BooleanValue.class, Value.NumberValue.class, Value.StringValue.class, Value.ArrayValue.class, Value.ObjectValue.class, Value.FunctionValue.class}, (Object)value2, n)) {
            case 0: {
                Value.NullValue nullValue = (Value.NullValue)value2;
                Object object = outOps.empty();
                return (U)object;
            }
            case 1: {
                Value.BooleanValue booleanValue = (Value.BooleanValue)value2;
                Object object = outOps.createBoolean(booleanValue.value());
                return (U)object;
            }
            case 2: {
                double value3;
                Value.NumberValue numberValue = (Value.NumberValue)value2;
                try {
                    double d;
                    value3 = d = numberValue.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object object = outOps.createNumeric((Number)value3);
                return (U)object;
            }
            case 3: {
                String value4;
                Value.StringValue stringValue = (Value.StringValue)value2;
                {
                    String string;
                    value4 = string = stringValue.value();
                }
                Object object = outOps.createString(value4);
                return (U)object;
            }
            case 4: {
                Value.ArrayValue arrayValue = (Value.ArrayValue)value2;
                Object object = outOps.createList(arrayValue.value().stream().map(value -> this.convertTo(outOps, (Value)value)));
                return (U)object;
            }
            case 5: {
                Value.ObjectValue objectValue = (Value.ObjectValue)value2;
                Object object = outOps.createMap(objectValue.value().entrySet().stream().map(entry -> Pair.of((Object)outOps.createString((String)entry.getKey()), this.convertTo(outOps, (Value)entry.getValue()))));
                return (U)object;
            }
            case 6: {
                Value.FunctionValue functionValue = (Value.FunctionValue)value2;
                throw new IllegalStateException("Cannot convert function value");
            }
        }
        throw new IllegalStateException("Unknown value type: " + String.valueOf(input));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Number> getNumberValue(Value input) {
        double value;
        if (!(input instanceof Value.NumberValue)) return DataResult.error(() -> "Not a number: " + String.valueOf(input));
        Value.NumberValue numberValue = (Value.NumberValue)input;
        try {
            double d;
            value = d = numberValue.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)value);
    }

    public Value createNumeric(Number i) {
        return new Value.NumberValue(i.doubleValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<String> getStringValue(Value input) {
        String value;
        if (!(input instanceof Value.StringValue)) return DataResult.error(() -> "Not a string: " + String.valueOf(input));
        Value.StringValue stringValue = (Value.StringValue)input;
        try {
            String string;
            value = string = stringValue.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)value);
    }

    public Value createString(String value) {
        return new Value.StringValue(value);
    }

    public DataResult<Value> mergeToList(Value list, Value value) {
        if (list instanceof Value.ArrayValue) {
            Value.ArrayValue array = (Value.ArrayValue)list;
            Value.ArrayValue result = new Value.ArrayValue(array.value());
            result.value().add(value);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "Not an array: " + String.valueOf(list));
    }

    public DataResult<Value> mergeToMap(Value map, Value key, Value value) {
        if (map instanceof Value.ObjectValue) {
            Value.ObjectValue object = (Value.ObjectValue)map;
            Value.ObjectValue result = new Value.ObjectValue(object.value());
            result.value().put(key.toString(), value);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "Not an object: " + String.valueOf(map));
    }

    public DataResult<Stream<Pair<Value, Value>>> getMapValues(Value input) {
        if (input instanceof Value.ObjectValue) {
            Value.ObjectValue objectValue = (Value.ObjectValue)input;
            return DataResult.success(objectValue.value().entrySet().stream().map(entry -> Pair.of((Object)new Value.StringValue((String)entry.getKey()), (Object)((Value)entry.getValue()))));
        }
        return DataResult.error(() -> "Not an object: " + String.valueOf(input));
    }

    public Value createMap(Stream<Pair<Value, Value>> map) {
        return new Value.ObjectValue(map.collect(Collectors.toMap(pair -> ((Value)pair.getFirst()).toString(), Pair::getSecond)));
    }

    public DataResult<Stream<Value>> getStream(Value input) {
        if (input instanceof Value.ArrayValue) {
            Value.ArrayValue arrayValue = (Value.ArrayValue)input;
            return DataResult.success(arrayValue.value().stream());
        }
        return DataResult.error(() -> "Not an array: " + String.valueOf(input));
    }

    public Value createList(Stream<Value> input) {
        return new Value.ArrayValue(input.toList());
    }

    public Value remove(Value input, String key) {
        if (input instanceof Value.ObjectValue) {
            Value.ObjectValue objectValue = (Value.ObjectValue)input;
            Value.ObjectValue newValue = new Value.ObjectValue();
            objectValue.value().forEach((k, v) -> {
                if (!k.equals(key)) {
                    newValue.value().put(k, v);
                }
            });
            return newValue;
        }
        return input;
    }
}

