/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchResourcePack;
import dev.mattidragon.jsonpatcher.misc.MetaPatchPackAccess;
import dev.mattidragon.jsonpatcher.patch.PatchingContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6861;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_6861.class})
public class LifecycledResourceManagerImplMixin
implements MetaPatchPackAccess {
    @Unique
    private MetapatchResourcePack jsonpatcher$metaPatchPack;
    @Unique
    private PatchingContext jsonpatcher$context;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/lang/Object;<init>()V", shift=At.Shift.AFTER, remap=false)})
    private void init(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
        this.jsonpatcher$metaPatchPack = new MetapatchResourcePack(type);
        this.jsonpatcher$context = new PatchingContext(type);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initPatches(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
        this.jsonpatcher$context.load((class_3300)this);
    }

    @ModifyReturnValue(method={"getAllNamespaces"}, at={@At(value="RETURN")})
    private Set<String> patchNamespaceSet(Set<String> value) {
        HashSet<String> set = new HashSet<String>(value);
        set.addAll(this.jsonpatcher$metaPatchPack.method_14406(this.jsonpatcher$metaPatchPack.type));
        return set;
    }

    @ModifyReturnValue(method={"getAllResources"}, at={@At(value="RETURN")})
    private List<class_3298> injectResourcesIntoGetAll(List<class_3298> original, class_2960 id) {
        if (this.jsonpatcher$metaPatchPack.isDeleted(id)) {
            return new ArrayList<class_3298>();
        }
        ArrayList<class_3298> list = new ArrayList<class_3298>(original);
        class_3298 metaResource = this.jsonpatcher$metaPatchPack.makeResource(id);
        if (metaResource != null) {
            list.add(metaResource);
        }
        list.forEach(resource -> this.jsonpatcher$context.patchResource(id, (class_3298)resource));
        return list;
    }

    @ModifyReturnValue(method={"getResource"}, at={@At(value="RETURN")})
    private Optional<class_3298> injectResourcesIntoGet(Optional<class_3298> original, class_2960 id) {
        if (this.jsonpatcher$metaPatchPack.isDeleted(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.jsonpatcher$metaPatchPack.makeResource(id)).or(() -> original).map(resource -> {
            this.jsonpatcher$context.patchResource(id, (class_3298)resource);
            return resource;
        });
    }

    @ModifyReturnValue(method={"findResources"}, at={@At(value="RETURN")})
    private Map<class_2960, class_3298> injectResourcesIntoFind(Map<class_2960, class_3298> map, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        map.putAll(this.jsonpatcher$metaPatchPack.findResources(startingPath, allowedPathPredicate));
        map.keySet().removeIf(this.jsonpatcher$metaPatchPack::isDeleted);
        map.forEach(this.jsonpatcher$context::patchResource);
        return map;
    }

    @ModifyReturnValue(method={"findAllResources"}, at={@At(value="RETURN")})
    private Map<class_2960, List<class_3298>> injectResourcesIntoFindAll(Map<class_2960, List<class_3298>> map, String startingPath, Predicate<class_2960> allowedPathPredicate) {
        this.jsonpatcher$metaPatchPack.findResources(startingPath, allowedPathPredicate).forEach((id, resource) -> map.computeIfAbsent((class_2960)id, i -> new ArrayList()).add(resource));
        map.keySet().removeIf(this.jsonpatcher$metaPatchPack::isDeleted);
        map.forEach((id, resources) -> resources.forEach(resource -> this.jsonpatcher$context.patchResource((class_2960)id, (class_3298)resource)));
        return map;
    }

    @Override
    public MetapatchResourcePack jsonpatcher$getMetaPatchPack() {
        return this.jsonpatcher$metaPatchPack;
    }
}

