/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch;

import com.google.common.base.Suppliers;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.config.Config;
import dev.mattidragon.jsonpatcher.lang.ast.SourceSpan;
import dev.mattidragon.jsonpatcher.lang.ast.meta.MetadataHolder;
import dev.mattidragon.jsonpatcher.lang.ast.meta.MetadataKey;
import dev.mattidragon.jsonpatcher.lang.ast.meta.TreeMetadata;
import dev.mattidragon.jsonpatcher.lang.error.Diagnostic;
import dev.mattidragon.jsonpatcher.lang.error.Diagnostics;
import dev.mattidragon.jsonpatcher.lang.error.DiagnosticsBuilder;
import dev.mattidragon.jsonpatcher.lang.parse.Lexer;
import dev.mattidragon.jsonpatcher.lang.parse.Parser;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataElement;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataNull;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataString;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.PatchMetadata;
import dev.mattidragon.jsonpatcher.lang.runtime.bytecode.CompilationException;
import dev.mattidragon.jsonpatcher.lang.runtime.bytecode.compiler.CompilerOptions;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.EvaluationEnvironment;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.Library;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.LibraryGroup;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.ProgramData;
import dev.mattidragon.jsonpatcher.lang.runtime.lib.builder.LibraryBuilder;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchLibrary;
import dev.mattidragon.jsonpatcher.misc.DumpManager;
import dev.mattidragon.jsonpatcher.misc.MetadataOps;
import dev.mattidragon.jsonpatcher.misc.ModLibraryGroups;
import dev.mattidragon.jsonpatcher.patch.ErrorLogger;
import dev.mattidragon.jsonpatcher.patch.LibraryMetadata;
import dev.mattidragon.jsonpatcher.patch.Patch;
import dev.mattidragon.jsonpatcher.patch.PatchLoaderDiagnostic;
import dev.mattidragon.jsonpatcher.patch.PatchStorage;
import dev.mattidragon.jsonpatcher.patch.PatchTarget;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatchLoader;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatchScanner;
import dev.mattidragon.jsonpatcher.trust.TrustChecker;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7367;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class PatchLoader {
    private static final class_7654 FINDER = new class_7654("jsonpatch", ".jsonpatch");

    public static PatchStorage loadPatches(Executor executor, class_3300 manager, class_3264 resourceType) {
        String message;
        Map files = FINDER.method_45113(manager);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List<Patch> patches = Collections.synchronizedList(new ArrayList());
        EvaluationEnvironment environment = new EvaluationEnvironment(CompilerOptions.DEFAULT);
        if (((Config)Config.MANAGER.get()).dumpCompiledPatches()) {
            environment.enableDumping(DumpManager.getDumpPath("classes/" + resourceType.method_14413()));
        }
        environment.enableLogging(value -> JsonPatcher.RELOAD_LOGGER.info("Debug message from patch: {}", value));
        environment.bootstrap();
        MetapatchLibrary metapatchLibrary = new MetapatchLibrary(manager);
        environment.addLibrary(new Library(ModLibraryGroups.METAPATCH, "metapatch", (Supplier)Suppliers.memoize(() -> new LibraryBuilder(MetapatchLibrary.class, (Object)metapatchLibrary).build())));
        GlobalPatchLoader.getGlobalLibs().forEach(arg_0 -> ((EvaluationEnvironment)environment).addLibrary(arg_0));
        AtomicInteger errorCount = new AtomicInteger(0);
        AtomicInteger warnCount = new AtomicInteger(0);
        for (Map.Entry entry : files.entrySet()) {
            TrustLevel trust = TrustChecker.getTrust(((class_3298)entry.getValue()).method_45304());
            futures.add(CompletableFuture.runAsync(() -> {
                Patch patch = PatchLoader.loadPatch(FINDER.method_45115((class_2960)entry.getKey()), (class_2960)entry.getKey(), (class_7367<InputStream>)((class_7367)() -> ((class_3298)((class_3298)entry.getValue())).method_14482()), environment, errorCount, warnCount, trust);
                if (patch != null) {
                    patches.add(patch);
                }
            }, executor));
        }
        for (Map.Entry<Object, Object> entry : GlobalPatchScanner.scan(resourceType).entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                Patch patch = PatchLoader.loadPatch(((class_2960)entry.getKey()).method_45134(path -> "/" + path.substring(path.indexOf(47, 1) + 1)), (class_2960)entry.getKey(), (class_7367<InputStream>)((class_7367)entry.getValue()), environment, errorCount, warnCount, TrustLevel.MODPACK);
                if (patch != null) {
                    patches.add(patch);
                }
            }, executor));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        if (errorCount.get() > 0) {
            message = "Failed to load %s patch(es). See jsonpatcher/jsonpatcher.log for details".formatted(errorCount.get());
            ErrorLogger.CURRENT.get().accept(class_2561.method_43470((String)message).method_27692(class_124.field_1061));
            JsonPatcher.MAIN_LOGGER.error(message);
            if (((Config)Config.MANAGER.get()).throwOnFailure()) {
                throw new IllegalStateException(message);
            }
        }
        if (warnCount.get() > 0) {
            message = "Encountered warnings while loading %s patch(es). See jsonpatcher/jsonpatcher.log for details".formatted(warnCount.get());
            ErrorLogger.CURRENT.get().accept(class_2561.method_43470((String)message).method_27692(class_124.field_1054));
            JsonPatcher.MAIN_LOGGER.warn(message);
        }
        return new PatchStorage(patches, metapatchLibrary);
    }

    @Nullable
    private static Patch loadPatch(class_2960 id, class_2960 location, class_7367<InputStream> streamSupplier, EvaluationEnvironment environment, AtomicInteger errorCount, AtomicInteger warnCount, TrustLevel trust) {
        try {
            String code = new String(((InputStream)streamSupplier.get()).readAllBytes(), StandardCharsets.UTF_8);
            DiagnosticsBuilder diagnosticsBuilder = new DiagnosticsBuilder();
            Lexer.Result lexResult = Lexer.lex((String)code, (String)id.toString(), (DiagnosticsBuilder)diagnosticsBuilder);
            Parser.Result parseResult = Parser.parse((List)lexResult.tokens(), (DiagnosticsBuilder)diagnosticsBuilder);
            Patch built = PatchLoader.validateAndBuild(id, parseResult, environment, diagnosticsBuilder, trust);
            Diagnostics diagnostics = diagnosticsBuilder.build();
            Collection errors = diagnostics.errors();
            Collection warnings = diagnostics.warnings();
            if (!errors.isEmpty()) {
                JsonPatcher.RELOAD_LOGGER.error("Failed to load patch {} from {}:\n{}", new Object[]{id, location, errors.stream().map(Diagnostic::toDisplay).collect(Collectors.joining("\n"))});
                errorCount.incrementAndGet();
            }
            if (!warnings.isEmpty()) {
                JsonPatcher.RELOAD_LOGGER.warn("Warnings while loading patch {} from {}:\n{}", new Object[]{id, location, warnings.stream().map(Diagnostic::toDisplay).collect(Collectors.joining("\n"))});
                warnCount.addAndGet(warnings.size());
            }
            if (errors.isEmpty()) {
                return built;
            }
        }
        catch (CompilationException | IOException | IllegalStateException e) {
            JsonPatcher.RELOAD_LOGGER.error("Failed to load patch {} from {}", new Object[]{id, location, e});
            errorCount.incrementAndGet();
        }
        catch (RuntimeException e) {
            JsonPatcher.RELOAD_LOGGER.error("Unexpected error while loading patches", (Throwable)e);
            errorCount.incrementAndGet();
        }
        return null;
    }

    @Nullable
    private static Patch validateAndBuild(class_2960 id, Parser.Result result, EvaluationEnvironment environment, DiagnosticsBuilder diagnosticsBuilder, TrustLevel trust) {
        EvaluationEnvironment.AddedProgram added;
        HashSet<String> roles = new HashSet<String>();
        TreeMetadata treeMeta = result.treeMetadata();
        PatchMetadata meta = result.metadata();
        if (meta.has("enabled") && !meta.getBoolean("enabled")) {
            return null;
        }
        if (!PatchLoader.validateVersion(diagnosticsBuilder, meta, treeMeta)) {
            return null;
        }
        List<PatchTarget> target = PatchLoader.getTargets(diagnosticsBuilder, meta, treeMeta, roles);
        double priority = PatchLoader.getPriority(meta);
        LibraryMetadata libraryMetadata = PatchLoader.getLibraryMetadata(diagnosticsBuilder, meta, treeMeta, roles);
        boolean isMetapatch = PatchLoader.isIsMetapatch(diagnosticsBuilder, meta, treeMeta, roles);
        if (roles.size() > 1) {
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(null, "A single patch may only have one role. %s has %s: %s".formatted(id, roles.size(), String.join((CharSequence)", ", roles)), Diagnostic.Kind.ERROR, 5));
        }
        Object className = "jsonpatcher_patches/" + id.method_12836().replaceAll("[-.]", "_") + "/" + id.method_12832().replaceAll("[-.]", "_");
        className = ((String)className).replaceAll("/(?=/)", "");
        ProgramData.Builder builder = ProgramData.builder((Parser.Result)result).scriptName(id.toString()).className((String)className);
        if (isMetapatch) {
            builder.allowLibraryGroup(ModLibraryGroups.METAPATCH);
        }
        if (trust.ordinal() >= ((Config)Config.MANAGER.get()).reflectionMinTrustLevel().ordinal()) {
            builder.allowLibraryGroup(LibraryGroup.REFLECTION);
        }
        try {
            added = environment.addProgram(builder.build());
        }
        catch (CompilationException e) {
            e.getErrors().forEach(arg_0 -> ((DiagnosticsBuilder)diagnosticsBuilder).addDiagnostic(arg_0));
            return null;
        }
        if (libraryMetadata != null) {
            com.google.common.base.Supplier supplier = () -> {
                Value.ObjectValue obj = new Value.ObjectValue();
                added.run(obj);
                return obj;
            };
            if (libraryMetadata.shared()) {
                supplier = Suppliers.memoize(() -> supplier.get());
            }
            Library library = new Library(LibraryGroup.DEFAULT, id.toString(), (Supplier)supplier);
            environment.addLibrary(library);
        }
        return new Patch(added, id, target, priority, isMetapatch, trust);
    }

    private static boolean isIsMetapatch(DiagnosticsBuilder diagnosticsBuilder, PatchMetadata meta, TreeMetadata treeMeta, HashSet<String> roles) {
        boolean isMetapatch = meta.has("metapatch");
        if (isMetapatch) {
            if (!(meta.get("metapatch") instanceof MetadataNull)) {
                diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)meta.get("metapatch"), MetadataKey.MAIN_POS).orElse(null), "Metapatch metadata should be empty", Diagnostic.Kind.ERROR, 4));
            }
            roles.add("metapatch");
        }
        return isMetapatch;
    }

    @Nullable
    public static LibraryMetadata getLibraryMetadata(DiagnosticsBuilder diagnosticsBuilder, PatchMetadata meta, TreeMetadata treeMeta, HashSet<String> roles) {
        if (meta.has("library")) {
            MetadataElement data = meta.get("library");
            if (data instanceof MetadataNull) {
                return LibraryMetadata.DEFAULT;
            }
            DataResult dataResult = LibraryMetadata.CODEC.parse((DynamicOps)MetadataOps.INSTANCE, (Object)data);
            if (dataResult.isSuccess()) {
                return (LibraryMetadata)dataResult.getOrThrow();
            }
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)data, MetadataKey.MAIN_POS).orElse(null), "Failed to parse library metadata: %s".formatted(((DataResult.Error)dataResult.error().orElseThrow()).message()), Diagnostic.Kind.ERROR, 3));
            roles.add("library");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateVersion(DiagnosticsBuilder diagnosticsBuilder, PatchMetadata meta, TreeMetadata treeMeta) {
        String version;
        MetadataElement metadataElement;
        if (meta.has("version") && (metadataElement = meta.get("version")) instanceof MetadataString) {
            MetadataString metadataString = (MetadataString)metadataElement;
            try {
                String string;
                version = string = metadataString.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        } else {
            SourceSpan pos = meta.has("version") ? (SourceSpan)treeMeta.get((MetadataHolder)meta.get("version"), MetadataKey.MAIN_POS).orElse(null) : null;
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(pos, "Unsupported patch version '%s'".formatted(meta.getString("version")), Diagnostic.Kind.ERROR, 0));
            return false;
        }
        if (!JsonPatcher.isSupportedVersion(version)) {
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)meta.get("version"), MetadataKey.MAIN_POS).orElse(null), "Unsupported patch version '%s'".formatted(meta.getString("version")), Diagnostic.Kind.ERROR, 1));
            return false;
        }
        return true;
    }

    private static List<PatchTarget> getTargets(DiagnosticsBuilder diagnosticsBuilder, PatchMetadata meta, TreeMetadata treeMeta, HashSet<String> roles) {
        List target;
        if (meta.has("target")) {
            DataResult dataResult = PatchTarget.LIST_CODEC.parse((DynamicOps)MetadataOps.INSTANCE, (Object)meta.get("target"));
            if (dataResult.isSuccess()) {
                target = (List)dataResult.getOrThrow();
            } else {
                target = List.of();
                diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)meta.get("target"), MetadataKey.MAIN_POS).orElse(null), "Failed to parse target: %s".formatted(((DataResult.Error)dataResult.error().orElseThrow()).message()), Diagnostic.Kind.ERROR, 2));
            }
            roles.add("patch");
        } else {
            target = List.of();
        }
        return target;
    }

    public static double getPriority(PatchMetadata meta) {
        double priority = meta.has("priority") ? meta.getNumber("priority") : 0.0;
        return priority;
    }
}

