/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchLibrary;
import dev.mattidragon.jsonpatcher.patch.Patch;
import dev.mattidragon.jsonpatcher.patch.PatchTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public final class PatchStorage {
    private final Multimap<String, Patch> namespacePatches = LinkedHashMultimap.create();
    private final Multimap<String, Patch> pathPatches = LinkedHashMultimap.create();
    private final Multimap<String, Patch> namespaceFilteredPatches = LinkedHashMultimap.create();
    private final Multimap<class_2960, Patch> directIdPatches = LinkedHashMultimap.create();
    private final List<Patch> nonTrivialPatches = new ArrayList<Patch>();
    private final List<Patch> alwaysActivePatches = new ArrayList<Patch>();
    private final Map<class_2960, Patch> libraries = new HashMap<class_2960, Patch>();
    private final List<Patch> metaPatches = new ArrayList<Patch>();
    private final MetapatchLibrary metapatchLibrary;

    public PatchStorage(List<Patch> patches, MetapatchLibrary metapatchLibrary) {
        this.metapatchLibrary = metapatchLibrary;
        for (Patch patch : patches) {
            if (patch.isMeta()) {
                this.metaPatches.add(patch);
            }
            patch.target().forEach(target -> {
                Optional simplePath = target.path().map(PatchTarget.Path::path).flatMap(either -> either.left());
                Optional splitPath = target.path().map(PatchTarget.Path::path).flatMap(either -> either.right());
                if (target.regex().isPresent() || splitPath.isPresent()) {
                    if (target.namespace().isPresent()) {
                        this.namespaceFilteredPatches.put((Object)target.namespace().get(), (Object)patch);
                    } else {
                        this.nonTrivialPatches.add(patch);
                    }
                    return;
                }
                if (target.namespace().isPresent() && simplePath.isPresent()) {
                    class_2960 id = class_2960.method_12829((String)(target.namespace().get() + ":" + (String)simplePath.get()));
                    if (id == null) {
                        return;
                    }
                    this.directIdPatches.put((Object)id, (Object)patch);
                    return;
                }
                if (target.namespace().isPresent()) {
                    this.namespacePatches.put((Object)target.namespace().get(), (Object)patch);
                    return;
                }
                if (simplePath.isPresent()) {
                    this.pathPatches.put((Object)((String)simplePath.get()), (Object)patch);
                    return;
                }
                this.alwaysActivePatches.add(patch);
            });
            this.libraries.put(patch.id(), patch);
        }
    }

    public boolean hasPatches(class_2960 id) {
        if (!this.alwaysActivePatches.isEmpty()) {
            return true;
        }
        if (this.namespacePatches.containsKey((Object)id.method_12836())) {
            return true;
        }
        if (this.pathPatches.containsKey((Object)id.method_12832())) {
            return true;
        }
        if (this.directIdPatches.containsKey((Object)id)) {
            return true;
        }
        if (this.namespaceFilteredPatches.get((Object)id.method_12836()).stream().anyMatch(patch -> patch.target().stream().anyMatch(target -> target.test(id)))) {
            return true;
        }
        return this.nonTrivialPatches.stream().anyMatch(patch -> patch.target().stream().anyMatch(target -> target.test(id)));
    }

    public Collection<Patch> getPatches(class_2960 id) {
        HashSet<Patch> patchSet = new HashSet<Patch>(this.alwaysActivePatches);
        this.namespacePatches.entries().stream().filter(entry -> ((String)entry.getKey()).equals(id.method_12836())).map(Map.Entry::getValue).forEach(patchSet::add);
        this.pathPatches.entries().stream().filter(entry -> ((String)entry.getKey()).equals(id.method_12832())).map(Map.Entry::getValue).forEach(patchSet::add);
        this.directIdPatches.entries().stream().filter(entry -> ((class_2960)entry.getKey()).equals((Object)id)).map(Map.Entry::getValue).forEach(patchSet::add);
        this.nonTrivialPatches.stream().filter(patch -> patch.target().stream().anyMatch(target -> target.test(id))).forEach(patchSet::add);
        this.namespaceFilteredPatches.get((Object)id.method_12836()).stream().filter(patch -> patch.target().stream().anyMatch(target -> target.test(id))).forEach(patchSet::add);
        ArrayList<Patch> patchList = new ArrayList<Patch>(patchSet);
        patchList.sort(Comparator.comparingDouble(Patch::priority));
        return patchList;
    }

    public Collection<Patch> getMetaPatches() {
        return this.metaPatches;
    }

    public int size() {
        return this.libraries.size();
    }

    public MetapatchLibrary metapatchLibrary() {
        return this.metapatchLibrary;
    }
}

