/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2960;

public record PatchTarget(Optional<String> namespace, Optional<Path> path, Optional<String> regex) implements Predicate<class_2960>
{
    private static final Codec<PatchTarget> ID_CODEC = class_2960.field_25139.flatComapMap(id -> new PatchTarget(Optional.of(id.method_12836()), Optional.of(new Path((Either<String, Pair<String, String>>)Either.left((Object)id.method_12832()))), Optional.empty()), target -> {
        if (target.regex.isPresent()) {
            return DataResult.error(() -> "Can't serialize to id form with regex");
        }
        if (target.namespace.isEmpty()) {
            return DataResult.error(() -> "Can't serialize to id form without namespace");
        }
        if (target.path.isEmpty()) {
            return DataResult.error(() -> "Can't serialize to id form without path");
        }
        DataResult checkedPath = (DataResult)target.path.get().path.map(DataResult::success, pair -> DataResult.error(() -> "Can't serialize split path to id form"));
        return checkedPath.map(path -> class_2960.method_60655((String)target.namespace.get(), (String)path));
    });
    private static final Codec<PatchTarget> SPLIT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("namespace").forGetter(target -> target.namespace), (App)Path.CODEC.optionalFieldOf("path").forGetter(target -> target.path), (App)Codec.STRING.validate(regex -> {
        try {
            Pattern.compile(regex);
            return DataResult.success((Object)regex);
        }
        catch (PatternSyntaxException e) {
            return DataResult.error(() -> "Invalid regex: %s".formatted(e.getMessage()));
        }
    }).optionalFieldOf("regex").forGetter(target -> target.regex)).apply((Applicative)instance, PatchTarget::new)).validate(target -> {
        if (target.namespace.isEmpty() && target.path.isEmpty() && target.regex.isEmpty()) {
            return DataResult.error(() -> "Empty targets aren't allowed");
        }
        return DataResult.success((Object)target);
    });
    public static final Codec<PatchTarget> CODEC = Codec.withAlternative(ID_CODEC, SPLIT_CODEC);
    public static final Codec<List<PatchTarget>> LIST_CODEC = Codec.either((Codec)CODEC.listOf(), CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((PatchTarget)list.getFirst())) : Either.left((Object)list));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(class_2960 identifier) {
        if (this.namespace.map(identifier.method_12836()::equals).orElse(true) == false) return false;
        if (this.path.map(path -> path.test(identifier.method_12832())).orElse(true) == false) return false;
        if (this.regex.map(identifier.toString()::matches).orElse(true) == false) return false;
        return true;
    }

    public record Path(Either<String, Pair<String, String>> path) implements Predicate<String>
    {
        public static final Codec<Path> CODEC = Codec.either((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("start").forGetter(Pair::getFirst), (App)Codec.STRING.fieldOf("end").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new))).xmap(Path::new, Path::path);

        @Override
        public boolean test(String path) {
            return (Boolean)this.path.map(path::equals, pair -> path.startsWith((String)pair.getFirst()) && path.endsWith((String)pair.getSecond()));
        }
    }
}

