/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonWriter;
import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.config.Config;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import dev.mattidragon.jsonpatcher.metapatch.MetapatchResourcePack;
import dev.mattidragon.jsonpatcher.misc.DumpManager;
import dev.mattidragon.jsonpatcher.misc.GsonConverter;
import dev.mattidragon.jsonpatcher.misc.MetaPatchPackAccess;
import dev.mattidragon.jsonpatcher.patch.BasePatch;
import dev.mattidragon.jsonpatcher.patch.ErrorLogger;
import dev.mattidragon.jsonpatcher.patch.Patch;
import dev.mattidragon.jsonpatcher.patch.PatchStorage;
import dev.mattidragon.jsonpatcher.patch.PatchingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7367;
import org.apache.commons.lang3.mutable.MutableObject;

public class Patcher {
    public static final ExecutorService PATCH_RUNNER = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("JsonPatcher-Patch-Runner").factory());
    private static final Gson GSON = new Gson();
    private final class_3264 resourceType;
    private final PatchStorage patches;

    public Patcher(class_3264 resourceType, PatchStorage patches) {
        this.resourceType = resourceType;
        this.patches = patches;
    }

    public boolean hasPatches(class_2960 id) {
        return this.patches.hasPatches(id);
    }

    private JsonElement applyPatches(JsonElement json, class_2960 id) {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        MutableObject activeJson = new MutableObject((Object)class_3518.method_15295((JsonElement)json, (String)"patched file"));
        try {
            for (Patch patch : this.patches.getPatches(id)) {
                Value.ObjectValue root = GsonConverter.fromGson((JsonObject)activeJson.getValue());
                long timeBeforePatch = System.nanoTime();
                boolean success = Patcher.runPatch(patch, PATCH_RUNNER, errors::add, root);
                long timeAfterPatch = System.nanoTime();
                JsonPatcher.RELOAD_LOGGER.debug("Patched {} with {} in {}ms", new Object[]{id, patch.id(), (double)(timeAfterPatch - timeBeforePatch) / 1000000.0});
                if (!success) continue;
                activeJson.setValue((Object)GsonConverter.toGson(root));
            }
        }
        catch (RuntimeException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            errors.forEach(error -> JsonPatcher.RELOAD_LOGGER.error("Error while patching {}", (Object)id, error));
            String message = "Encountered %s error(s) while patching %s. See jsonpatcher/jsonpatcher.log for details".formatted(errors.size(), id);
            ErrorLogger.CURRENT.get().accept(class_2561.method_43470((String)message).method_27692(class_124.field_1061));
            if (((Config)Config.MANAGER.get()).throwOnFailure()) {
                throw new PatchingException(message);
            }
            JsonPatcher.MAIN_LOGGER.error(message);
        }
        return (JsonElement)activeJson.getValue();
    }

    public static boolean runPatch(BasePatch patch, Executor executor, Consumer<RuntimeException> errorConsumer, Value.ObjectValue root) {
        try {
            CompletableFuture.runAsync(() -> patch.program().run(root), executor).get(((Config)Config.MANAGER.get()).patchTimeoutMillis(), TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException cause = (RuntimeException)throwable;
                errorConsumer.accept(cause);
            } else {
                throwable = e.getCause();
                if (throwable instanceof StackOverflowError) {
                    StackOverflowError cause = (StackOverflowError)throwable;
                    errorConsumer.accept(new PatchingException("Stack overflow while applying patch %s".formatted(patch.name()), cause));
                } else {
                    errorConsumer.accept(new RuntimeException("Unexpected error while applying patch %s".formatted(patch.name()), e));
                }
            }
        }
        catch (InterruptedException e) {
            errorConsumer.accept(new PatchingException("Async error while applying patch %s".formatted(patch.name()), e));
        }
        catch (TimeoutException e) {
            errorConsumer.accept(new PatchingException("Timeout while applying patch %s. Check for infinite loops and increase the timeout in the config.".formatted(patch.name()), e));
        }
        return false;
    }

    public class_7367<InputStream> patchInputStream(class_2960 id, class_7367<InputStream> stream) {
        if (!this.hasPatches(id)) {
            return stream;
        }
        try {
            JsonPatcher.RELOAD_LOGGER.debug("Patching {}", (Object)id);
            JsonElement json = (JsonElement)GSON.fromJson((Reader)new InputStreamReader((InputStream)stream.get()), JsonElement.class);
            json = this.applyPatches(json, id);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            GSON.toJson(json, new JsonWriter((Writer)writer));
            writer.close();
            DumpManager.dumpIfEnabled(id, this.resourceType, json);
            return () -> new ByteArrayInputStream(out.toByteArray());
        }
        catch (JsonParseException | IOException e) {
            if (((Config)Config.MANAGER.get()).throwOnFailure()) {
                throw new RuntimeException("Failed to patch json at %s".formatted(id), e);
            }
            JsonPatcher.RELOAD_LOGGER.error("Failed to patch json at {}", (Object)id, (Object)e);
            return stream;
        }
    }

    public void runMetaPatches(class_3300 manager, Executor executor) {
        if (!(manager instanceof MetaPatchPackAccess)) {
            JsonPatcher.MAIN_LOGGER.error("Failed to run meta patches: resource manager doesn't expose meta pack");
            return;
        }
        MetaPatchPackAccess packAccess = (MetaPatchPackAccess)manager;
        MetapatchResourcePack metaPack = packAccess.jsonpatcher$getMetaPatchPack();
        metaPack.clear();
        this.patches.metapatchLibrary().clear();
        ArrayList<Patch> metaPatches = new ArrayList<Patch>(this.patches.getMetaPatches());
        metaPatches.sort(Comparator.comparing(Patch::priority));
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        try {
            for (Patch patch : metaPatches) {
                long timeBeforePatch = System.nanoTime();
                Patcher.runPatch(patch, executor, errors::add, new Value.ObjectValue());
                long timeAfterPatch = System.nanoTime();
                JsonPatcher.RELOAD_LOGGER.debug("Ran meta patch {} in {}ms", (Object)patch.id(), (Object)((double)(timeAfterPatch - timeBeforePatch) / 1000000.0));
            }
        }
        catch (RuntimeException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            errors.forEach(error -> JsonPatcher.RELOAD_LOGGER.error("Error while running meta patch", (Throwable)error));
            String message = "Encountered %s error(s) while running meta patches. See jsonpatcher/jsonpatcher.log for details".formatted(errors.size());
            ErrorLogger.CURRENT.get().accept(class_2561.method_43470((String)message).method_27692(class_124.field_1061));
            if (((Config)Config.MANAGER.get()).throwOnFailure()) {
                throw new PatchingException(message);
            }
            JsonPatcher.MAIN_LOGGER.error(message);
        }
        this.patches.metapatchLibrary().apply(metaPack);
    }
}

